<?php
header("Content-Type: application/json; charset=UTF-8");
include_once 'database.php';

$database = new Database();
$db = $database->getConnection();

if ($db) {
    try {
        // SQL para crear la tabla de conversaciones
        $sql_conversations = "
        CREATE TABLE IF NOT EXISTS `chat_conversations` (
          `id` INT AUTO_INCREMENT PRIMARY KEY,
          `name` VARCHAR(255) NULL,
          `group_photo_url` VARCHAR(255) NULL,
          `is_group_chat` BOOLEAN NOT NULL DEFAULT FALSE,
          `created_by` INT NULL,
          `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
          FOREIGN KEY (`created_by`) REFERENCES `professionals`(`id`) ON DELETE SET NULL
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";

        $db->exec($sql_conversations);

        // SQL para crear la tabla de miembros de la conversación
        $sql_members = "
        CREATE TABLE IF NOT EXISTS `chat_conversation_members` (
          `conversation_id` INT NOT NULL,
          `user_id` INT NOT NULL,
          `joined_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
          PRIMARY KEY (`conversation_id`, `user_id`),
          FOREIGN KEY (`conversation_id`) REFERENCES `chat_conversations`(`id`) ON DELETE CASCADE,
          FOREIGN KEY (`user_id`) REFERENCES `professionals`(`id`) ON DELETE CASCADE
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";

        $db->exec($sql_members);

        // SQL para crear la tabla de mensajes
        $sql_messages = "
        CREATE TABLE IF NOT EXISTS `chat_messages` (
          `id` INT AUTO_INCREMENT PRIMARY KEY,
          `conversation_id` INT NOT NULL,
          `sender_id` INT NOT NULL,
          `message_content` TEXT NOT NULL,
          `timestamp` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
          FOREIGN KEY (`conversation_id`) REFERENCES `chat_conversations`(`id`) ON DELETE CASCADE,
          FOREIGN KEY (`sender_id`) REFERENCES `professionals`(`id`) ON DELETE CASCADE
        ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;";

        $db->exec($sql_messages);

        echo json_encode(["message" => "Tablas de chat creadas exitosamente."]);

    } catch (PDOException $e) {
        http_response_code(500);
        echo json_encode(["message" => "Error al crear las tablas de chat: " . $e->getMessage()]);
    }
} else {
    http_response_code(500);
    echo json_encode(["message" => "No se pudo conectar a la base de datos."]);
}
?>