<?php
header("Content-Type: application/json");

$database_path = '../config/database.json';

function get_database() {
    global $database_path;
    if (!file_exists($database_path)) {
        return ["professionals" => [], "clients" => [], "projects" => [], "tasks" => [], "content_grids" => [], "grid_posts" => [], "media_plans" => []];
    }
    $json_data = file_get_contents($database_path);
    $data = json_decode($json_data, true);
    if (!isset($data['media_plans'])) $data['media_plans'] = [];
    return $data;
}

function save_database($data) {
    global $database_path;
    file_put_contents($database_path, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

$method = $_SERVER['REQUEST_METHOD'];
$project_id = isset($_GET['project_id']) ? (int)$_GET['project_id'] : null;
$plan_id = isset($_GET['id']) ? (int)$_GET['id'] : null;

if ($method === 'GET') {
    $db = get_database();
    $plans = $db['media_plans'] ?? [];

    if ($plan_id !== null) {
        $plan = array_values(array_filter($plans, function($p) use ($plan_id) {
            return $p['id'] === $plan_id;
        }));
        echo json_encode(count($plan) > 0 ? $plan[0] : null);
    } elseif ($project_id !== null) {
        $project_plans = array_values(array_filter($plans, function($p) use ($project_id) {
            return isset($p['project_id']) && $p['project_id'] == $project_id;
        }));
        echo json_encode($project_plans);
    } else {
        echo json_encode($plans); // Devolver todos los planes si no hay ID específico
    }

} elseif ($method === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    if (empty($input['project_id']) || empty($input['name']) || empty($input['start_date']) || empty($input['end_date'])) {
        http_response_code(400);
        echo json_encode(['error' => 'Nombre, fechas y ID de proyecto son obligatorios.']);
        exit;
    }

    $db = get_database();
    
    $new_id = empty($db['media_plans']) ? 1 : max(array_column($db['media_plans'], 'id')) + 1;
    
    $new_plan = [
        'id' => $new_id,
        'project_id' => (int)$input['project_id'],
        'name' => $input['name'],
        'objective' => $input['objective'] ?? '',
        'audience' => $input['audience'] ?? '',
        'budget' => (float)($input['budget'] ?? 0),
        'start_date' => $input['start_date'],
        'end_date' => $input['end_date'],
        'items' => [], // Aquí se guardarán las líneas del plan (TV, Radio, etc.)
        'responsables' => $input['responsables'] ?? []
    ];

    $db['media_plans'][] = $new_plan;
    save_database($db);

    http_response_code(201);
    echo json_encode($new_plan);

} elseif ($method === 'PUT' && $plan_id !== null) {
    $input = json_decode(file_get_contents('php://input'), true);
    $db = get_database();
    
    $updated_plan = null;
    $found = false;

    foreach ($db['media_plans'] as $key => $plan) {
        if ($plan['id'] === $plan_id) {
            $db['media_plans'][$key] = array_merge($plan, $input);
            $db['media_plans'][$key]['id'] = $plan_id; // Asegurar que el ID no cambie
            $updated_plan = $db['media_plans'][$key];
            $found = true;
            break;
        }
    }

    if ($found) {
        save_database($db);
        echo json_encode($updated_plan);
    } else {
        http_response_code(404);
        echo json_encode(['error' => 'Plan de medios no encontrado para actualizar']);
    }
} elseif ($method === 'DELETE' && $plan_id !== null) {
    $db = get_database();
    $original_count = count($db['media_plans']);
    
    $db['media_plans'] = array_values(array_filter($db['media_plans'], function($p) use ($plan_id) {
        return $p['id'] !== $plan_id;
    }));
    
    if (count($db['media_plans']) < $original_count) {
        save_database($db);
        http_response_code(204);
    } else {
        http_response_code(404);
        echo json_encode(['error' => 'Plan de medios no encontrado']);
    }
} else {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido']);
}
?>