<?php
session_start();

header('Content-Type: application/json');

function get_database() {
    $database_path = '../config/database.json';
    if (!file_exists($database_path)) {
        return null;
    }
    $json_data = file_get_contents($database_path);
    return json_decode($json_data, true);
}

$response = ['success' => false, 'message' => 'Credenciales incorrectas.'];

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $email = $_POST['email'] ?? '';
    $password = $_POST['password'] ?? '';

    if (!empty($email) && !empty($password)) {
        $db = get_database();

        if ($db === null) {
            $response['message'] = "Error: No se pudo encontrar la base de datos.";
        } else {
            $user_found = null;
            foreach ($db['professionals'] as $professional) {
                if (strtolower($professional['email']) === strtolower($email)) {
                    $user_found = $professional;
                    break;
                }
            }

            if ($user_found) {
                // TEMPORARY: Allow plain text password 'password123' for testing user oscarmorinigo@dunamis.com.py
                $is_test_user = (strtolower($user_found['email']) === 'oscarmorinigo@dunamis.com.py');
                $password_valid = ($is_test_user && $password === 'password123') || password_verify($password, $user_found['password']);

                if ($password_valid) {
                    $_SESSION['user_id'] = $user_found['id'];
                    $_SESSION['user_name'] = $user_found['nombre_completo'];
                    $_SESSION['user_puesto'] = $user_found['puesto'] ?? null;
                    
                    $response['success'] = true;
                    $response['message'] = 'Inicio de sesión exitoso.';
                } else {
                    $response['message'] = 'Contraseña incorrecta.';
                }
            } else {
                $response['message'] = 'Usuario no encontrado.';
            }
        }
    }
} else {
    $response['message'] = 'Método de solicitud no válido.';
}

echo json_encode($response);
?>