<?php
header("Content-Type: application/json");

$database_path = '../config/database.json';

// Función para leer la base de datos
function get_database() {
    global $database_path;
    if (!file_exists($database_path)) {
        return ["professionals" => [], "clients" => [], "projects" => [], "tasks" => [], "content_grids" => [], "grid_posts" => []];
    }
    $json_data = file_get_contents($database_path);
    $data = json_decode($json_data, true);
    if (!isset($data['grid_posts'])) {
        $data['grid_posts'] = [];
    }
    return $data;
}

// Función para guardar la base de datos
function save_database($data) {
    global $database_path;
    file_put_contents($database_path, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

$method = $_SERVER['REQUEST_METHOD'];
$grid_id = isset($_GET['grid_id']) ? (int)$_GET['grid_id'] : null;
$id = isset($_GET['id']) ? (int)$_GET['id'] : null;

if ($method === 'GET') {
    $db = get_database();
    $posts = $db['grid_posts'] ?? [];

    if ($grid_id !== null) {
        $grid_items = array_values(array_filter($posts, function($item) use ($grid_id) {
            return isset($item['grid_id']) && $item['grid_id'] == $grid_id;
        }));
        echo json_encode($grid_items);
    } else {
        echo json_encode($posts); // Devolver todos los posts si no hay grid_id
    }

} elseif ($method === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    if (empty($input['grid_id'])) {
        http_response_code(400);
        echo json_encode(['error' => 'El grid_id es obligatorio']);
        exit;
    }

    $db = get_database();
    
    $new_id = empty($db['grid_posts']) ? 1 : max(array_column($db['grid_posts'], 'id')) + 1;
    
    $new_item = [
        'id' => $new_id,
        'grid_id' => (int)$input['grid_id'],
        'fecha_posteo' => $input['fecha_posteo'] ?? '',
        'hora_posteo' => $input['hora_posteo'] ?? '',
        'objetivo' => $input['objetivo'] ?? '',
        'redes' => $input['redes'] ?? [],
        'tipo_contenido' => $input['tipo_contenido'] ?? '',
        'hook' => $input['hook'] ?? '',
        'copy' => $input['copy'] ?? '',
        'hashtags' => $input['hashtags'] ?? '',
        'cta' => $input['cta'] ?? '',
        'publico_objetivo' => $input['publico_objetivo'] ?? '',
        'resultado_esperado' => $input['resultado_esperado'] ?? '',
        'realizado' => false,
        'fecha_realizado' => null
    ];

    $db['grid_posts'][] = $new_item;
    save_database($db);

    http_response_code(201);
    echo json_encode($new_item);

} elseif ($method === 'PUT' && $id !== null) {
    $input = json_decode(file_get_contents('php://input'), true);
    $db = get_database();
    
    $updated_item = null;
    $found = false;

    foreach ($db['grid_posts'] as $key => $item) {
        if ($item['id'] === $id) {
            // Lógica especial para el check de "realizado"
            if (isset($input['realizado']) && $input['realizado'] === true && $item['realizado'] === false) {
                $input['fecha_realizado'] = date('Y-m-d H:i:s');
            } elseif (isset($input['realizado']) && $input['realizado'] === false) {
                $input['fecha_realizado'] = null;
            }

            $db['grid_posts'][$key] = array_merge($item, $input);
            $db['grid_posts'][$key]['id'] = $id; // Asegurar que el ID no cambie
            $updated_item = $db['grid_posts'][$key];
            $found = true;
            break;
        }
    }

    if ($found) {
        save_database($db);
        echo json_encode($updated_item);
    } else {
        http_response_code(404);
        echo json_encode(['error' => 'Posteo no encontrado']);
    }

} elseif ($method === 'DELETE' && $id !== null) {
    $db = get_database();
    $original_count = count($db['grid_posts']);
    $db['grid_posts'] = array_values(array_filter($db['grid_posts'], function($item) use ($id) {
        return $item['id'] !== $id;
    }));
    
    if (count($db['grid_posts']) < $original_count) {
        save_database($db);
        http_response_code(204);
    } else {
        http_response_code(404);
        echo json_encode(['error' => 'Elemento no encontrado']);
    }

} else {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido o ID no proporcionado']);
}
?>