<?php
header("Content-Type: application/json");

$database_path = '../config/database.json';

function get_database() {
    global $database_path;
    if (!file_exists($database_path)) {
        return [];
    }
    $json_data = file_get_contents($database_path);
    return json_decode($json_data, true);
}

function save_database($data) {
    global $database_path;
    file_put_contents($database_path, json_encode($data, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
}

$method = $_SERVER['REQUEST_METHOD'];
$id = isset($_GET['id']) ? (int)$_GET['id'] : null;

if ($method === 'GET') {
    $db = get_database();
    $expenses = $db['expenses'] ?? [];

    if ($id !== null) {
        $expense = array_values(array_filter($expenses, function($exp) use ($id) {
            return $exp['id'] === $id;
        }));
        if (count($expense) > 0) {
            echo json_encode($expense[0]);
        } else {
            http_response_code(404);
            echo json_encode(['error' => 'Gasto no encontrado']);
        }
    } else {
        echo json_encode($expenses);
    }
} elseif ($method === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);
    $db = get_database();

    if (!isset($db['expenses'])) {
        $db['expenses'] = [];
    }

    $new_id = empty($db['expenses']) ? 1 : max(array_column($db['expenses'], 'id')) + 1;
    
    $new_expense = $input;
    $new_expense['id'] = $new_id;

    $db['expenses'][] = $new_expense;
    save_database($db);

    http_response_code(201);
    echo json_encode($new_expense);

} elseif ($method === 'PUT' && $id !== null) {
    $input = json_decode(file_get_contents('php://input'), true);
    $db = get_database();
    
    $found = false;
    foreach ($db['expenses'] as $key => $expense) {
        if ($expense['id'] === $id) {
            $db['expenses'][$key] = array_merge($expense, $input);
            $db['expenses'][$key]['id'] = $id;
            $updated_expense = $db['expenses'][$key];
            $found = true;
            break;
        }
    }

    if ($found) {
        save_database($db);
        echo json_encode($updated_expense);
    } else {
        http_response_code(404);
        echo json_encode(['error' => 'Gasto no encontrado para actualizar']);
    }

} elseif ($method === 'DELETE' && $id !== null) {
    $db = get_database();
    
    $original_count = count($db['expenses'] ?? []);
    $db['expenses'] = array_values(array_filter($db['expenses'] ?? [], function($exp) use ($id) {
        return $exp['id'] !== $id;
    }));
    
    if (count($db['expenses']) < $original_count) {
        save_database($db);
        http_response_code(204);
    } else {
        http_response_code(404);
        echo json_encode(['error' => 'Gasto no encontrado']);
    }

} else {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido o ID no proporcionado']);
}
?>