<?php
header("Content-Type: application/json");

// Simulación de un endpoint que llama a una IA

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'POST') {
    $input = json_decode(file_get_contents('php://input'), true);

    // 1. Recibir el contexto del frontend
    $clientName = $input['clientName'] ?? 'un cliente';
    $projectName = $input['projectName'] ?? 'un nuevo proyecto';
    $projectDescription = $input['projectDescription'] ?? 'sin descripción';
    $marketingType = $input['marketingType'] ?? 'Mixto';

    // 2. Construir el prompt para la IA
    $prompt = "Actúa como un Director de Estrategia de Marketing. Para la empresa '$clientName', y su proyecto '$projectName', ".
              "cuyos objetivos son: '$projectDescription', y con un enfoque en marketing '$marketingType', ".
              "desarrolla una propuesta de marketing. Responde únicamente con un JSON que contenga tres claves: 'estrategico', 'tactico' y 'operativo'.";

    // 3. (HIPOTÉTICO) Aquí se haría la llamada a la API de la IA (ej. Gemini)
    // $ai_response = call_gemini_api($prompt); 
    // $response_data = json_decode($ai_response, true);

    // 4. Como simulación, devolvemos una respuesta de ejemplo
    sleep(2); // Simular el tiempo de respuesta de la IA

    $response_data = [
        'estrategico' => "Análisis de mercado y competencia para identificar oportunidades. Definición de KPIs clave (ej. Aumento de leads en 20%). Posicionamiento de la marca como líder en el sector X.",
        'tactico' => "Campaña de Google Ads enfocada en palabras clave de alta intención. Creación de 3 artículos de blog mensuales optimizados para SEO. Lanzamiento de una campaña de email marketing a la base de datos existente.",
        'operativo' => "Publicar 5 veces por semana en Instagram y Facebook. Monitorear comentarios y responder en menos de 2 horas. Generar reporte semanal de rendimiento de campañas."
    ];

    echo json_encode($response_data);

} else {
    http_response_code(405);
    echo json_encode(['error' => 'Método no permitido']);
}
?>