<?php

function get_mock_response($task_type) {
    switch ($task_type) {
        case 'generate_strategy':
            return [
                'estrategico' => "Análisis de mercado y competencia para identificar oportunidades. Definición de KPIs clave (ej. Aumento de leads en 20%). Posicionamiento de la marca como líder en el sector X.",
                'tactico' => "Campaña de Google Ads enfocada en palabras clave de alta intención. Creación de 3 artículos de blog mensuales optimizados para SEO. Lanzamiento de una campaña de email marketing a la base de datos existente.",
                'operativo' => "Publicar 5 veces por semana en Instagram y Facebook. Monitorear comentarios y responder en menos de 2 horas. Generar reporte semanal de rendimiento de campañas."
            ];
        case 'generate_grid_posts':
            return [
                [
                    "fecha_posteo" => date('Y-m-d', strtotime('+2 days')), "hora_posteo" => "19:00", "tipo_contenido" => "Carrusel Educativo", "redes" => ["Instagram", "Facebook"],
                    "objetivo" => "Educar sobre el problema que resolvemos", "hook" => "¿Sabías que el 70% de las empresas luchan con esto?", "copy" => "Desliza para descubrir 3 errores comunes en [tema] y cómo puedes superarlos fácilmente. ➡️",
                    "hashtags" => "#TipsDeNegocio #Crecimiento #MarketingDigital", "cta" => "Guarda este post para más tarde.", "publico_objetivo" => "Emprendedores y dueños de PYMES", "resultado_esperado" => "100 guardados, 20 comentarios"
                ],
                [
                    "fecha_posteo" => date('Y-m-d', strtotime('+5 days')), "hora_posteo" => "20:30", "tipo_contenido" => "Video Testimonial", "redes" => ["Instagram", "LinkedIn"],
                    "objetivo" => "Generar confianza y prueba social", "hook" => "Así es como [Cliente] transformó su negocio.", "copy" => "¡Nuestro cliente [NombreCliente] logró [resultado] en solo 2 semanas! 🚀 Escucha su historia y cómo lo hicimos posible. ¿Quieres ser el próximo?",
                    "hashtags" => "#CasoDeExito #ResultadosReales #Testimonio", "cta" => "¡Comenta 'QUIERO' y te contactamos por DM!", "publico_objetivo" => "Gerentes de Marketing", "resultado_esperado" => "50 comentarios, 10 leads"
                ],
            ];
        case 'generate_creative_asset':
            return [
                'creative_asset' => "Prompt para Midjourney: 'Fotografía cinematográfica de un escritorio de oficina moderno y minimalista al amanecer. Un único rayo de sol ilumina un gráfico de crecimiento ascendente en un monitor. El ambiente es de calma, enfoque y optimismo. Estilo fotorrealista, colores cálidos, --ar 16:9'"
            ];
        default:
            return ['error' => 'Respuesta simulada no encontrada para esta tarea.'];
    }
}

?>