document.addEventListener('DOMContentLoaded', function() {
    const calendarEl = document.getElementById('projects-calendar');
    const PROJECTS_API_URL = 'api/projects.php';

    async function initialLoad() {
        try {
            const projectsRes = await fetch(PROJECTS_API_URL);
            if (!projectsRes.ok) throw new Error('No se pudieron cargar los proyectos.');
            
            const projects = await projectsRes.json();
            renderCalendar(projects);

        } catch (error) {
            console.error("Error en la carga de la agenda de proyectos:", error);
            calendarEl.innerHTML = `<div class="alert alert-danger">Error al cargar el calendario: ${error.message}</div>`;
        }
    }

    function renderCalendar(projects) {
        const projectEvents = projects.filter(p => p.fecha_fin_estimada).map(project => ({
            title: `Vence Proyecto: ${project.nombre_proyecto}`,
            start: project.fecha_fin_estimada,
            allDay: true,
            url: `project-detail.html?id=${project.id}`,
            backgroundColor: '#6f42c1', // Púrpura
            borderColor: '#6f42c1',
            extendedProps: {
                status: project.estado
            }
        }));

        const calendar = new FullCalendar.Calendar(calendarEl, {
            initialView: 'dayGridMonth',
            locale: 'es',
            headerToolbar: {
                left: 'prev,next today',
                center: 'title',
                right: 'dayGridMonth,timeGridWeek,listWeek'
            },
            events: projectEvents
        });
        calendar.render();
    }

    initialLoad();
});