document.addEventListener('DOMContentLoaded', function() {
    const calendarEl = document.getElementById('media-plan-calendar');
    const MEDIA_PLANS_API_URL = 'api/media_plans.php';

    async function initialLoad() {
        try {
            const mediaPlansRes = await fetch(MEDIA_PLANS_API_URL);
            if (!mediaPlansRes.ok) throw new Error('No se pudieron cargar los planes de medios.');
            
            const mediaPlans = await mediaPlansRes.json();
            renderCalendar(mediaPlans);

        } catch (error) {
            console.error("Error en la carga de la agenda de plan de medios:", error);
            calendarEl.innerHTML = `<div class="alert alert-danger">Error al cargar el calendario: ${error.message}</div>`;
        }
    }

    function renderCalendar(mediaPlans) {
        const mediaPlanEvents = mediaPlans.filter(plan => plan.end_date).map(plan => ({
            title: `Fin Plan: ${plan.name}`,
            start: plan.end_date,
            allDay: true,
            url: `media-plan-detail.html?project_id=${plan.project_id}`,
            backgroundColor: '#20c997', // Teal
            borderColor: '#20c997',
            extendedProps: {
                budget: plan.budget
            }
        }));

        const calendar = new FullCalendar.Calendar(calendarEl, {
            initialView: 'dayGridMonth',
            locale: 'es',
            headerToolbar: {
                left: 'prev,next today',
                center: 'title',
                right: 'dayGridMonth,timeGridWeek,listWeek'
            },
            events: mediaPlanEvents
        });
        calendar.render();
    }

    initialLoad();
});