<?php
header('Content-Type: application/json');

// --- Verificación de reCAPTCHA v3 ---
$config_file = 'config.json';
$recaptcha_secret_key = '';
if (file_exists($config_file)) {
    $config = json_decode(file_get_contents($config_file), true);
    $recaptcha_secret_key = $config['recaptcha_secret_key'] ?? '';
}

if (!empty($recaptcha_secret_key) && isset($_POST['recaptcha_token'])) {
    $recaptcha_url = 'https://www.google.com/recaptcha/api/siteverify';
    $recaptcha_response = file_get_contents($recaptcha_url . '?secret=' . $recaptcha_secret_key . '&response=' . $_POST['recaptcha_token']);
    $recaptcha_data = json_decode($recaptcha_response);

    if (!$recaptcha_data->success || $recaptcha_data->score < 0.5) {
        // No pasó la verificación de reCAPTCHA
        $response = ['success' => false, 'message' => 'Verificación de reCAPTCHA fallida. Inténtalo de nuevo.'];
        echo json_encode($response);
        exit;
    }
} elseif (!empty($recaptcha_secret_key) && !isset($_POST['recaptcha_token'])) {
    // Token no enviado cuando se esperaba
    $response = ['success' => false, 'message' => 'Falta el token de reCAPTCHA.'];
    echo json_encode($response);
    exit;
}

$response = ['success' => false, 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    $response['message'] = 'Método no permitido.';
    echo json_encode($response);
    exit;
}

// 1. Recoger y validar datos
$name = isset($_POST['name']) ? trim($_POST['name']) : '';
$email = isset($_POST['email']) ? trim($_POST['email']) : '';
$fileName = isset($_POST['fileName']) ? trim($_POST['fileName']) : 'Desconocido';
$filePath = isset($_POST['filePath']) ? trim($_POST['filePath']) : '';

if (empty($name) || !filter_var($email, FILTER_VALIDATE_EMAIL) || empty($filePath)) {
    $response['message'] = 'Por favor, proporciona un nombre, un email válido y asegúrate de que el archivo es correcto.';
    echo json_encode($response);
    exit;
}

// 2. Preparar el nuevo registro
$new_download = [
    'date' => date('Y-m-d H:i:s'),
    'name' => $name,
    'email' => $email,
    'resource' => $fileName
];

// 3. Guardar en el archivo JSON
$file_path = 'downloads.json';
$downloads = [];

if (file_exists($file_path)) {
    $json_content = file_get_contents($file_path);
    $downloads = json_decode($json_content, true) ?: [];
}

array_unshift($downloads, $new_download);

if (file_put_contents($file_path, json_encode($downloads, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE))) {
    $response['success'] = true;
    $response['filePath'] = $filePath; // Devolver la ruta del archivo para la descarga
} else {
    $response['message'] = 'Error del servidor al guardar el registro.';
}

echo json_encode($response);
?>