<?php
// Verificar si la solicitud es de tipo POST.
if ($_SERVER["REQUEST_METHOD"] == "POST") {

    // 1. Recoger y limpiar los datos del formulario.
    $name = isset($_POST['name']) ? htmlspecialchars($_POST['name']) : 'No especificado';
    $email = isset($_POST['email']) ? htmlspecialchars($_POST['email']) : 'No especificado';
    $message = isset($_POST['message']) ? htmlspecialchars($_POST['message']) : 'Sin mensaje';
    $services = isset($_POST['services']) && is_array($_POST['services']) ? $_POST['services'] : [];

    // 2. Crear un nuevo array asociativo para el contacto.
    $new_contact = [
        'date' => date('d/m/Y H:i:s'),
        'name' => $name,
        'email' => $email,
        'services' => $services,
        'message' => $message,
        'status' => 'new' // Añadir un estado para seguimiento
    ];

    // 3. Leer el archivo JSON existente, añadir el nuevo contacto y guardarlo.
    $file_path = 'contacts.json';
    try {
        // Leer el contenido del archivo.
        $json_content = file_get_contents($file_path);
        if ($json_content === false) {
            throw new Exception("No se pudo leer el archivo.");
        }

        // Decodificar el JSON a un array de PHP.
        $contacts = json_decode($json_content, true);
        if (!is_array($contacts)) {
            // Si el JSON está malformado o vacío, empezar con un array vacío.
            $contacts = [];
        }

        // Añadir el nuevo contacto al principio del array (para que los más nuevos aparezcan primero).
        array_unshift($contacts, $new_contact);

        // Codificar el array de vuelta a JSON con formato legible.
        $new_json_content = json_encode($contacts, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
        if ($new_json_content === false) {
            throw new Exception("Error al codificar a JSON.");
        }

        // Escribir el contenido de vuelta en el archivo.
        if (file_put_contents($file_path, $new_json_content, LOCK_EX) === false) {
            throw new Exception("No se pudo escribir en el archivo.");
        }

        // 4. Redirigir con éxito.
        header("Location: contacto.html?success=1");
        exit;

    } catch (Exception $e) {
        // En caso de cualquier error en el proceso, redirigir con un código de error.
        // En un entorno de producción, aquí se registraría el error $e->getMessage().
        header("Location: contacto.html?error=2"); // Error genérico de guardado
        exit;
    }

} else {
    // Si no es una solicitud POST, redirigir.
    header("Location: contacto.html");
    exit;
}
?>