document.addEventListener('DOMContentLoaded', () => {
    // --- Cargar Cabecera y Pie de Página ---
    const loadComponent = (url, elementId) => {
        fetch(url)
            .then(response => response.text())
            .then(data => {
                document.getElementById(elementId).innerHTML = data;
                // Una vez cargada la cabecera, inicializamos sus componentes interactivos
                if (elementId === 'main-header') {
                    initializeHeader();
                }
            })
            .catch(error => console.error(`Error al cargar ${url}:`, error));
    };

    loadComponent('header.html', 'main-header');
    loadComponent('footer.html', 'main-footer');

    const initializeHeader = () => {
        // --- Lógica para el Menú Móvil ---
        const mobileMenuButton = document.getElementById('mobile-menu-button');
        const mobileMenu = document.getElementById('mobile-menu');

        if (mobileMenuButton && mobileMenu) {
            mobileMenuButton.addEventListener('click', () => {
                mobileMenu.classList.toggle('hidden');
            });
        }

        // --- Lógica para el Dropdown de Servicios ---
        const serviciosDropdown = document.getElementById('servicios-dropdown');
        const serviciosMenu = document.getElementById('servicios-menu');

        if (serviciosDropdown && serviciosMenu) {
            serviciosDropdown.addEventListener('mouseenter', () => {
                serviciosMenu.classList.remove('hidden');
            });
            serviciosDropdown.addEventListener('mouseleave', () => {
                serviciosMenu.classList.add('hidden');
            });
        }

        // --- Lógica para Resaltar Página Activa y Botón Volver ---
        const currentPage = window.location.pathname.split('/').pop();
        const navLinks = document.querySelectorAll('#servicios-menu a, header nav > a');
        const backButton = document.getElementById('back-button');
        const mobileBackButton = document.getElementById('mobile-back-button');
        const servicePages = [
            'apertura-sociedades.html',
            'contabilidad-finanzas.html',
            'planificacion-tributaria.html',
            'bpo-administracion.html',
            'gestion-inversiones.html',
            'servicios-agropecuarios.html',
            'registro-marca.html'
        ];

        if (servicePages.includes(currentPage)) {
            if(backButton) {
                backButton.classList.remove('hidden');
                backButton.classList.add('md:flex');
            }
            if(mobileBackButton) {
                mobileBackButton.classList.remove('hidden');
            }
        }

        navLinks.forEach(link => {
            const linkPage = link.getAttribute('href').split('/').pop();
            if (linkPage === currentPage) {
                link.classList.add('font-bold', 'text-secondary');
            }
        });
    };

    // --- Lógica para el Mensaje de Error del Login (si existe en la página) ---
    const urlParams = new URLSearchParams(window.location.search);
    const error = urlParams.get('error');
    const errorMessage = document.getElementById('error-message');

    if (error === '1' && errorMessage) {
        errorMessage.classList.add('visible');
    }
});