<?php
// Iniciar la sesión para manejar las variables de autenticación.
session_start();

// --- Configuración de Usuario ---
// En un caso real, estos datos vendrían de una base de datos.
$valid_username = 'admin';
$valid_password_hash = password_hash('password123', PASSWORD_DEFAULT); // ¡Nunca guardes contraseñas en texto plano!

// --- Lógica de Autenticación ---

// Verificar si el método de la solicitud es POST.
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    $username = $_POST['username'];
    $password = $_POST['password'];

    // Verificar si el usuario es válido y la contraseña coincide con el hash.
    if ($username === $valid_username && password_verify($password, $valid_password_hash)) {
        // Autenticación exitosa.
        // Guardar en la sesión que el usuario está autenticado.
        $_SESSION['loggedin'] = true;
        $_SESSION['username'] = $username;

        // Redirigir al panel de administración.
        header("Location: difsaadmin.php");
        exit;
    } else {
        // Autenticación fallida.
        // Redirigir de vuelta al login con un mensaje de error.
        header("Location: login.html?error=1");
        exit;
    }
} else {
    // Si alguien intenta acceder a login.php directamente, lo redirigimos a la página de login.
    header("Location: login.html");
    exit;
}
?>