<?php
header('Content-Type: application/json');

$response = ['success' => false, 'message' => ''];

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $index = filter_input(INPUT_POST, 'index', FILTER_VALIDATE_INT);

    if ($index === null || $index === false) {
        $response['message'] = 'Índice de contacto no válido.';
        echo json_encode($response);
        exit;
    }

    $file_path = 'contacts.json';

    try {
        // Leer el contenido actual del archivo JSON
        $json_content = file_get_contents($file_path);
        if ($json_content === false) {
            throw new Exception('No se pudo leer el archivo de contactos.');
        }

        $contacts = json_decode($json_content, true);
        if (!is_array($contacts)) {
            throw new Exception('El archivo de contactos está malformado o vacío.');
        }

        // Verificar si el índice es válido
        if (!isset($contacts[$index])) {
            throw new Exception('El contacto especificado no existe.');
        }

        // Eliminar el contacto del array
        array_splice($contacts, $index, 1);

        // Codificar el array modificado a JSON
        $new_json_content = json_encode($contacts, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE);
        if ($new_json_content === false) {
            throw new Exception('Error al codificar los contactos a JSON.');
        }

        // Escribir el nuevo contenido en el archivo
        if (file_put_contents($file_path, $new_json_content, LOCK_EX) === false) {
            throw new Exception('No se pudo escribir en el archivo de contactos.');
        }

        $response['success'] = true;
        $response['message'] = 'Contacto eliminado con éxito.';

    } catch (Exception $e) {
        $response['message'] = 'Error en el servidor: ' . $e->getMessage();
    }
} else {
    $response['message'] = 'Método de solicitud no permitido.';
}

echo json_encode($response);
?>