<?php
header('Content-Type: application/json');

function send_json_response($success, $message) {
    echo json_encode(['success' => $success, 'message' => $message]);
    exit;
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    send_json_response(false, 'Método no permitido.');
}

$postId = isset($_POST['postId']) ? trim($_POST['postId']) : null;

if (empty($postId)) {
    send_json_response(false, 'No se proporcionó el ID del artículo.');
}

$posts_file = 'blog_posts.json';

if (!file_exists($posts_file)) {
    send_json_response(false, 'El archivo de artículos no existe.');
}

$json_content = file_get_contents($posts_file);
$posts = json_decode($json_content, true);

if (!is_array($posts)) {
    send_json_response(false, 'El archivo de artículos está corrupto.');
}

$post_found = false;
$filtered_posts = [];

foreach ($posts as $post) {
    if ($post['id'] === $postId) {
        $post_found = true;
        // Opcional: eliminar archivos asociados del servidor
        if ($post['image'] && file_exists($post['image'])) unlink($post['image']);
        if ($post['attachment'] && file_exists($post['attachment'])) unlink($post['attachment']);
    } else {
        $filtered_posts[] = $post;
    }
}

if (!$post_found) {
    send_json_response(false, 'El artículo a eliminar no fue encontrado.');
}

if (file_put_contents($posts_file, json_encode($filtered_posts, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE))) {
    send_json_response(true, 'Artículo eliminado correctamente.');
} else {
    send_json_response(false, 'Error al guardar los cambios en el archivo JSON.');
}
?>