document.addEventListener('DOMContentLoaded', function() {
    // Carga la configuración del sitio (Analytics ID, reCAPTCHA key)
    fetch('config.json')
        .then(response => response.json())
        .then(config => {
            // Carga Google Analytics si el ID está presente
            if (config.analytics_id) {
                const gaScript = document.createElement('script');
                gaScript.async = true;
                gaScript.src = `https://www.googletagmanager.com/gtag/js?id=${config.analytics_id}`;
                document.head.appendChild(gaScript);

                window.dataLayer = window.dataLayer || [];
                function gtag(){dataLayer.push(arguments);}
                gtag('js', new Date());
                gtag('config', config.analytics_id);
            }

            // Carga reCAPTCHA si la clave del sitio está presente
            if (config.recaptcha_site_key) {
                // Almacena la clave en una variable global para que otros scripts la usen
                window.recaptchaSiteKey = config.recaptcha_site_key;
                
                const recaptchaScript = document.createElement('script');
                recaptchaScript.src = `https://www.google.com/recaptcha/api.js?render=${config.recaptcha_site_key}`;
                document.head.appendChild(recaptchaScript);
            }
        })
        .catch(error => {
            console.error('Error al cargar la configuración del sitio:', error);
        });
});