<?php
session_start();
header('Content-Type: application/json');

$jsonDbFile = 'usuarios.json';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);

    $username = $data['username'] ?? '';
    $password = $data['password'] ?? '';

    if (empty($username) || empty($password)) {
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'Usuario y contraseña son obligatorios.']);
        exit;
    }

    $users = file_exists($jsonDbFile) ? json_decode(file_get_contents($jsonDbFile), true) : [];

    foreach ($users as $user) {
        if ($user['username'] === $username && password_verify($password, $user['password_hash'])) {
            // Credenciales correctas, iniciar sesión
            $_SESSION['loggedin'] = true;
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['user_name'] = $user['name'];
            echo json_encode(['status' => 'success', 'message' => 'Inicio de sesión exitoso.']);
            exit;
        }
    }

    // Si el bucle termina, el usuario o la contraseña son incorrectos
    http_response_code(401); // Unauthorized
    echo json_encode(['status' => 'error', 'message' => 'Usuario o contraseña incorrectos.']);

} else {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Método no permitido.']);
}
?>