<?php
header('Content-Type: application/json');

$configFile = 'config.json';

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    // Si el archivo de configuración no existe, lo crea vacío.
    if (!file_exists($configFile)) {
        file_put_contents($configFile, json_encode([
            'analytics_id' => '',
            'recaptcha_site_key' => '',
            'recaptcha_secret_key' => ''
        ]));
    }
    // Envía el contenido del archivo de configuración.
    readfile($configFile);

} elseif ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $input = file_get_contents('php://input');
    $data = json_decode($input, true);

    // Sanitiza los datos recibidos.
    $configData = [
        'analytics_id' => htmlspecialchars($data['analytics_id'] ?? ''),
        'recaptcha_site_key' => htmlspecialchars($data['recaptcha_site_key'] ?? ''),
        'recaptcha_secret_key' => htmlspecialchars($data['recaptcha_secret_key'] ?? '')
    ];

    // Guarda los datos actualizados en el archivo de configuración.
    file_put_contents($configFile, json_encode($configData, JSON_PRETTY_PRINT));

    echo json_encode(['status' => 'success', 'message' => 'Configuración guardada con éxito.']);
} else {
    http_response_code(405);
    echo json_encode(['status' => 'error', 'message' => 'Método no permitido.']);
}
?>