<?php
// get_posts.php

header('Content-Type: application/json');

try {

// Comprobamos si la librería Parsedown existe ANTES de intentar cargarla.

$db_file = 'db.json';
$response = ['success' => false, 'posts' => []];

if (file_exists($db_file)) {
    $json_data = file_get_contents($db_file);
    // Forzar la decodificación como UTF-8 para evitar problemas con caracteres especiales.
    $json_data = mb_convert_encoding($json_data, 'UTF-8', 'auto');
    $db = json_decode($json_data, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        echo json_encode(['success' => false, 'message' => 'Error al decodificar el archivo JSON: ' . json_last_error_msg()]);
        exit;
    }
            $blogPosts = $db['blogPosts'] ?? [];
    
            /*
            $Parsedown = new Parsedown();
            $Parsedown->setSafeMode(true); // Previene la inyección de HTML/JS malicioso
    
            $processedPosts = [];
            foreach ($blogPosts as $post) {
                // Asegurarse de que el contenido exista antes de procesarlo
                if (isset($post['content'])) {
                    $post['content_html'] = $Parsedown->text($post['content']);
                    unset($post['content']); // No enviar el contenido crudo al frontend
                } else {
                    $post['content_html'] = ''; // O un valor predeterminado
                }
    
                $processedPosts[] = $post;
            }
            */
    
            $response['success'] = true;
            $response['posts'] = $blogPosts; // Devolver posts directamente} else {
    $response['message'] = 'No se encontraron artículos.';
}

echo json_encode($response);

} catch (Throwable $e) {
    // Registrar el error real en el servidor para depuración
    error_log('Error en get_posts.php: ' . $e->getMessage() . " en la línea " . $e->getLine());
    // Enviar una respuesta de error genérica al cliente
    echo json_encode(['success' => false, 'message' => 'Ocurrió un error inesperado en el servidor.']);
    exit;
}