<?php
// contact_handler.php

// --- INICIO: CÓDIGO DE DEPURACIÓN ---
$log_file = __DIR__ . '/contact_log.txt';
// Limpiar el log para cada nueva petición para no acumular información vieja.
// file_put_contents($log_file, ''); 
function write_log($message) {
    global $log_file;
    $timestamp = date('Y-m-d H:i:s');
    file_put_contents($log_file, "[$timestamp] " . print_r($message, true) . "\n", FILE_APPEND);
}

write_log("--- Inicio de la petición ---");
// --- FIN: CÓDIGO DE DEPURACIÓN ---

header('Content-Type: application/json');

try {
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        write_log("Error: Método no permitido: " . $_SERVER['REQUEST_METHOD']);
        http_response_code(405);
        echo json_encode(['success' => false, 'message' => 'Método no permitido.']);
        exit;
    }

    write_log("Petición POST recibida.");
    $input = json_decode(file_get_contents('php://input'), true);
    write_log("Datos recibidos: " . json_encode($input));

    if (json_last_error() !== JSON_ERROR_NONE) {
        write_log("Error: JSON mal formado.");
        throw new Exception("JSON de entrada mal formado.");
    }

    $name = trim($input['name'] ?? '');
    $email = trim($input['email'] ?? '');
    $country_code = trim($input['country_code'] ?? '');
    $phone = trim($input['phone'] ?? '');
    $subject = trim($input['subject'] ?? '');
    $message = trim($input['message'] ?? '');
    $honeypot = $input['honeypot'] ?? '';

    if (!empty($honeypot)) {
        write_log("Honeypot activado. Finalizando silenciosamente.");
        echo json_encode(['success' => true, 'message' => 'Tu mensaje fue enviado con éxito. En breve un consultor se comunicará con usted.']);
        exit;
    }

    if (empty($name) || empty($email) || empty($phone) || empty($subject) || empty($message)) {
        write_log("Error: Faltan campos requeridos.");
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'Por favor, complete todos los campos requeridos.']);
        exit;
    }

    if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
        write_log("Error: Email no válido: " . $email);
        http_response_code(400);
        echo json_encode(['success' => false, 'message' => 'La dirección de correo electrónico no es válida.']);
        exit;
    }

    /*
    write_log("Validación completada. Intentando enviar correo.");
    $to = "oscarmorinigo@dunamis.com.py, contacto@dunamis.com.py, didierluckmann@dunamis.com.py";
    $email_subject = "Nuevo Mensaje de Contacto desde Dunamis.com.py";
    $email_body = "Has recibido un nuevo mensaje...\n\n" . "Nombre: $name\n" . "Email: $email\n" . "Teléfono: $country_code $phone\n" . "Asunto: $subject\n\n" . "Mensaje:\n$message\n";
    $headers = "From: no-reply@dunamis.com.py\r\n" . "Reply-To: $email";

    $mail_sent = mail($to, $email_subject, $email_body, $headers);

    if (!$mail_sent) {
        write_log("Falló el envío de correo (función mail). Revisa la configuración de PHP mailer (php.ini) o el servidor SMTP.");
        throw new Exception("El servidor no pudo enviar el correo.");
    }
    
    write_log("Correo enviado exitosamente.");
    */

    $db_file = 'db.json';
    if (!file_exists($db_file)) {
        write_log("Error: El archivo db.json no existe.");
        throw new Exception("Error interno del servidor: db.json no encontrado.");
    }

    write_log("Leyendo db.json.");
    $db_content = file_get_contents($db_file);
    $db = json_decode($db_content, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        write_log("Error: db.json está mal formado.");
        throw new Exception("Error interno del servidor: db.json corrupto.");
    }
    
    write_log("db.json leído y decodificado correctamente.");

    $newContact = [
        'id' => uniqid('contact_'),
        'date' => date('Y-m-d H:i:s'),
        'name' => $name, 
        'email' => $email, 
        'phone' => $country_code . ' ' . $phone,
        'subject' => $subject, 
        'message' => $message,
        'read' => false
    ];
    
    if (!isset($db['contacts']) || !is_array($db['contacts'])) {
        $db['contacts'] = [];
        write_log("Advertencia: La clave 'contacts' no existía o no era un array. Se ha inicializado.");
    }

    array_unshift($db['contacts'], $newContact);
    write_log("Nuevo contacto añadido al array.");

    $write_result = file_put_contents($db_file, json_encode($db, JSON_PRETTY_PRINT));

    if ($write_result === false) {
        write_log("¡¡¡ERROR CRÍTICO!!! file_put_contents falló. Revisa los permisos del archivo/directorio.");
        throw new Exception("No se pudo guardar el mensaje.");
    }
    
    write_log("db.json guardado exitosamente. Bytes escritos: " . $write_result);
    write_log("--- Petición completada exitosamente ---");

    echo json_encode(['success' => true, 'message' => 'Tu mensaje fue enviado con éxito. En breve un consultor se comunicará con usted.']);

} catch (Exception $e) {
    write_log("EXCEPCIÓN CAPTURADA: " . $e->getMessage());
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Ocurrió un error inesperado en el servidor.']);
}