<?php
// panel.php
session_start();

// Prevenir el cach馥 del navegador
header("Cache-Control: no-store, no-cache, must-revalidate, max-age=0");
header("Cache-Control: post-check=0, pre-check=0", false);
header("Pragma: no-cache");

// Verificar si el usuario ha iniciado sesiףn.
// Si no, redirigirlo a la p찼gina de login.
if (!isset($_SESSION['user_logged_in']) || $_SESSION['user_logged_in'] !== true) {
    header("Location: dws-admin.html");
    exit;
}

// Cargar usuarios para mostrarlos en la tabla
$db_file = 'db.json';
$users = [];
if (file_exists($db_file)) {
    $json_data = file_get_contents($db_file);
    $db = json_decode($json_data, true, 512, JSON_UNESCAPED_UNICODE);
    if (json_last_error() !== JSON_ERROR_NONE) {
        // Si el JSON está mal, no podemos hacer mucho en el panel, pero evitamos un error fatal.
        $db = ['users' => [], 'contacts' => [], 'blogPosts' => [], 'leads' => [], 'crmLeads' => [], 'nextcloudLeads' => []];
    }

    $users = $db['users'] ?? [];
    $contacts = $db['contacts'] ?? [];
    $blogPosts = $db['blogPosts'] ?? [];
    $leads = $db['leads'] ?? [];
    $crmLeads = $db['crmLeads'] ?? [];
    $nextcloudLeads = $db['nextcloudLeads'] ?? [];

    // Contar notificaciones no leídas
    $unreadContacts = array_filter($contacts, fn($c) => !isset($c['read']) || $c['read'] === false);
    $unreadCrmLeads = array_filter($crmLeads, fn($l) => !isset($l['read']) || $l['read'] === false);
    $unreadNextcloudLeads = array_filter($nextcloudLeads, fn($l) => !isset($l['read']) || $l['read'] === false);
    $unreadCount = count($unreadContacts) + count($unreadCrmLeads) + count($unreadNextcloudLeads);
}

// Procesar leads para añadir el título del post
$processedLeads = [];
foreach ($leads as $lead) {
    $postTitle = 'Artículo no encontrado';
    foreach ($blogPosts as $post) {
        if (isset($post['attachments'])) {
            foreach ($post['attachments'] as $attachment) {
                if (basename($attachment['path']) === $lead['downloaded_file']) {
                    $postTitle = $post['title'];
                    break 2; // Salir de ambos bucles internos
                }
            }
        }
    }
    $processedLeads[] = $lead + ['post_title' => $postTitle];
}

?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Panel de Administración - Dunamis</title>
    <meta name="robots" content="noindex, nofollow">
    <!-- Favicon -->
    <link rel="icon" type="image/png" href="images/iso.png">

    <!-- Bootstrap CSS -->
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.min.css">

    <style>
        body {
            background-color: #f8f9fa;
        }
        .navbar {
            box-shadow: 0 2px 4px rgba(0,0,0,.1);
        }
        .notification-bell {
            position: relative;
        }
        .notification-badge {
            position: absolute;
            top: -5px;
            right: -5px;
            width: 10px;
            height: 10px;
            background-color: red;
            border-radius: 50%;
            border: 2px solid white;
        }
    </style>
</head>
<body>

    <!-- NAVEGACIÓN DEL PANEL -->
    <nav class="navbar navbar-expand-lg navbar-light bg-white sticky-top">
        <div class="container">
            <a class="navbar-brand" href="#">
                <img src="images/dunamislogo.png" alt="Dunamis Logo" style="max-height: 30px;">
                Panel de Administración
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#panelNavbar">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="panelNavbar">
                <ul class="navbar-nav ms-auto">
                    <!-- Campana de Notificaciones -->
                    <li class="nav-item dropdown">
                        <a class="nav-link notification-bell" href="#" id="notificationDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <i class="bi bi-bell fs-5"></i>
                            <?php if ($unreadCount > 0): ?>
                                <span class="notification-badge"></span>
                            <?php endif; ?>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end" aria-labelledby="notificationDropdown" id="notification-list">
                            <li class="dropdown-header">Notificaciones</li>
                            <?php foreach ($unreadContacts as $contact): ?>
                                <li><a class="dropdown-item" href="#" data-tab="listado-contactos-tab">Nuevo Contacto: <?php echo htmlspecialchars(substr($contact['name'], 0, 20)); ?>...</a></li>
                            <?php endforeach; ?>
                            <?php foreach ($unreadCrmLeads as $lead): ?>
                                <li><a class="dropdown-item" href="#" data-tab="leads-crm-tab">Nuevo Lead CRM: <?php echo htmlspecialchars(substr($lead['name'], 0, 20)); ?>...</a></li>
                            <?php endforeach; ?>
                            <?php foreach ($unreadNextcloudLeads as $lead): ?>
                                <li><a class="dropdown-item" href="#" data-tab="leads-nextcloud-tab">Nuevo Lead Nextcloud: <?php echo htmlspecialchars(substr($lead['name'], 0, 20)); ?>...</a></li>
                            <?php endforeach; ?>
                            <?php if ($unreadCount === 0): ?>
                                <li><p class="dropdown-item text-muted">No hay notificaciones nuevas.</p></li>
                            <?php endif; ?>
                        </ul>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="logout.php"><i class="bi bi-box-arrow-right me-1"></i>Cerrar Sesión</a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- CONTENIDO PRINCIPAL -->
    <main class="container mt-4">
        <div class="d-flex justify-content-between flex-wrap flex-md-nowrap align-items-center pt-3 pb-2 mb-3 border-bottom">
            <h1 class="h2">Dashboard</h1>
        </div>

        <!-- Navegación de Pestañas del Administrador -->
        <ul class="nav nav-tabs" id="adminTab" role="tablist">
            <li class="nav-item" role="presentation">
                <button class="nav-link active" id="crear-usuarios-tab" data-bs-toggle="tab" data-bs-target="#crear-usuarios-pane" type="button" role="tab" aria-controls="crear-usuarios-pane" aria-selected="true">Gestión de Usuarios</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="listado-contactos-tab" data-bs-toggle="tab" data-bs-target="#listado-contactos-pane" type="button" role="tab" aria-controls="listado-contactos-pane" aria-selected="false">Formularios de Contacto</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="cargar-blog-tab" data-bs-toggle="tab" data-bs-target="#cargar-blog-pane" type="button" role="tab" aria-controls="cargar-blog-pane" aria-selected="false">Cargar Blog</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="descargas-blog-tab" data-bs-toggle="tab" data-bs-target="#descargas-blog-pane" type="button" role="tab" aria-controls="descargas-blog-pane" aria-selected="false">Descargas del Blog</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="leads-crm-tab" data-bs-toggle="tab" data-bs-target="#leads-crm-pane" type="button" role="tab" aria-controls="leads-crm-pane" aria-selected="false">Leads CRM (Dolibarr)</button>
            </li>
            <li class="nav-item" role="presentation">
                <button class="nav-link" id="leads-nextcloud-tab" data-bs-toggle="tab" data-bs-target="#leads-nextcloud-pane" type="button" role="tab" aria-controls="leads-nextcloud-pane" aria-selected="false">Leads Nextcloud</button>
            </li>
        </ul>

        <!-- Contenido de las Pestañas -->
        <div class="tab-content p-3 border border-top-0" id="adminTabContent">
            <!-- 1. Crear Usuarios -->
            <div class="tab-pane fade show active" id="crear-usuarios-pane" role="tabpanel" aria-labelledby="crear-usuarios-tab">
                <h4>Gestión de Usuarios</h4>
                <hr>
                <div class="row">
                    <!-- Formulario para crear usuario -->
                    <div class="col-md-5">
                        <h5>Crear Nuevo Usuario</h5>
                        <form id="create-user-form">
                            <div class="mb-3">
                                <label for="new-name" class="form-label">Nombre Completo</label>
                                <input type="text" class="form-control" id="new-name" required>
                            </div>
                            <div class="mb-3">
                                <label for="new-email" class="form-label">Correo Electrónico</label>
                                <input type="email" class="form-control" id="new-email" required>
                            </div>
                            <div class="mb-3">
                                <label for="new-username" class="form-label">Nombre de Usuario</label>
                                <input type="text" class="form-control" id="new-username" required>
                            </div>
                            <div class="mb-3">
                                <label for="new-password" class="form-label">Contraseña Nueva</label>
                                <input type="password" class="form-control" id="new-password" required>
                            </div>
                            <button type="submit" class="btn btn-primary">Crear Usuario</button>
                        </form>
                        <div id="user-feedback" class="mt-3"></div>
                    </div>
                    <!-- Lista de usuarios existentes -->
                    <div class="col-md-7">
                        <h5>Usuarios Existentes</h5>
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th scope="col">Nombre</th>
                                        <th scope="col">Email</th>
                                        <th scope="col">Usuario</th>
                                        <th scope="col">Acciones</th>
                                    </tr>
                                </thead>
                                <tbody id="user-list">
                                    <?php foreach ($users as $user): ?>
                                    <tr data-username="<?php echo htmlspecialchars($user['username']); ?>">
                                        <td><?php echo htmlspecialchars($user['name'] ?? 'N/A'); ?></td>
                                        <td><?php echo htmlspecialchars($user['email'] ?? 'N/A'); ?></td>
                                        <td><?php echo htmlspecialchars($user['username']); ?></td>
                                        <td>
                                            <?php if ($user['username'] !== $_SESSION['username']): // No se puede eliminar a sí mismo ?>
                                            <button class="btn btn-danger btn-sm delete-user-btn">
                                                <i class="bi bi-trash"></i> Eliminar
                                            </button>
                                            <?php endif; ?>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>            </div>
            <!-- 2. Listado de Formularios -->
            <div class="tab-pane fade" id="listado-contactos-pane" role="tabpanel" aria-labelledby="listado-contactos-tab">
                <h4>Envíos del Formulario de Contacto</h4>
                <div id="contact-list-feedback"></div>
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead>
                            <tr>
                                <th scope="col">Fecha</th>
                                <th scope="col">Nombre</th>
                                <th scope="col">Contacto</th>
                                <th scope="col">Asunto</th>
                                <th scope="col">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($contacts)): ?>
                                <tr><td colspan="5" class="text-center py-4">No hay mensajes de contacto.</td></tr>
                            <?php else: ?>
                                <?php foreach ($contacts as $contact): // El estado 'read' se usa para la campana, no para ocultar ?>
                                <tr id="contact-row-<?php echo htmlspecialchars($contact['id']); ?>">
                                    <td><?php echo htmlspecialchars(date('d/m/Y H:i', strtotime($contact['date']))); ?></td>
                                    <td><?php echo htmlspecialchars($contact['name']); ?></td>
                                    <td>
                                        <div><?php echo htmlspecialchars($contact['email']); ?></div>
                                        <div class="small text-muted"><?php echo htmlspecialchars($contact['phone'] ?? ''); ?></div>
                                    </td>
                                    <td><?php echo htmlspecialchars($contact['subject']); ?></td>
                                    <td>
                                        <button class="btn btn-info btn-sm view-message-btn" data-bs-toggle="modal" data-bs-target="#contactModal" data-name="<?php echo htmlspecialchars($contact['name']); ?>" data-email="<?php echo htmlspecialchars($contact['email']); ?>" data-phone="<?php echo htmlspecialchars($contact['phone'] ?? ''); ?>" data-subject="<?php echo htmlspecialchars($contact['subject']); ?>" data-date="<?php echo htmlspecialchars(date('d/m/Y H:i', strtotime($contact['date']))); ?>" data-message="<?php echo htmlspecialchars($contact['message']); ?>"><i class="bi bi-envelope-open"></i> Ver</button>
                                        <button class="btn btn-danger btn-sm delete-contact-btn" data-id="<?php echo htmlspecialchars($contact['id']); ?>"><i class="bi bi-trash"></i></button>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <!-- 3. Cargar Contenidos para el Blog -->
            <div class="tab-pane fade" id="cargar-blog-pane" role="tabpanel" aria-labelledby="cargar-blog-tab">
                <h4>Gestor de Contenidos del Blog</h4>
                <hr>
                <div class="row">
                    <!-- Formulario para crear artículo -->
                    <div class="col-md-5">
                        <h5>Nuevo Artículo</h5>
                        <form id="create-blog-post-form">
                            <div class="mb-3">
                                <label for="post-title" class="form-label">Título del Artículo</label>
                                <input type="text" class="form-control" id="post-title" name="title" required>
                            </div>
                            <div class="mb-3">
                                <label for="post-subtitle" class="form-label">Subtítulo</label>
                                <input type="text" class="form-control" id="post-subtitle" name="subtitle" required>
                            </div>
                             <div class="mb-3">
                                <label for="post-image" class="form-label">Imagen Principal (después del subtítulo)</label>
                                <input class="form-control" type="file" id="post-image" name="image" accept="image/jpeg, image/png, image/webp" required>
                            </div>
                            <div class="mb-3">
                                <label for="post-category" class="form-label">Categoría</label>
                                <input type="text" class="form-control" id="post-category" name="category" required>
                            </div>
                            <div class="mb-3">
                                <label for="post-content" class="form-label">Contenido</label>
                                <textarea class="form-control" id="post-content" name="content" rows="10" required aria-describedby="contentHelp"></textarea>
                                <div id="contentHelp" class="form-text">Puedes usar etiquetas HTML como &lt;b&gt;, &lt;h2&gt;, &lt;ul&gt;, &lt;li&gt;, &lt;a href="..."&gt; para dar formato.</div>
                            </div>
                            <div class="mb-3">
                                <label for="post-attachments" class="form-label">Archivos Adjuntos (opcional)</label>
                                <input class="form-control" type="file" id="post-attachments" name="attachments[]" multiple>
                            </div>
                            <button type="submit" class="btn btn-primary">Publicar Artículo</button>
                        </form>
                        <div id="blog-post-feedback" class="mt-3"></div>
                    </div>
                    <!-- Lista de artículos existentes -->
                    <div class="col-md-7">
                        <h5>Artículos Publicados</h5>
                        <div class="table-responsive">
                            <table class="table table-striped table-hover">
                                <thead>
                                    <tr>
                                        <th scope="col">Título</th>
                                        <th scope="col">Categoría</th>
                                        <th scope="col">Fecha</th>
                                        <th scope="col">Acciones</th>
                                    </tr>
                                </thead>
                                <tbody id="blog-post-list">
                                    <?php foreach ($blogPosts as $post): ?>
                                    <?php
                                        // Construir la URL completa del artículo para mostrarla
                                        $postUrl = 'articulo.html?slug=' . urlencode($post['slug'] ?? '');
                                        $fullUrl = "http" . (isset($_SERVER['HTTPS']) ? "s" : "") . "://" . $_SERVER['HTTP_HOST'] . dirname($_SERVER['PHP_SELF']) . '/' . $postUrl;
                                    ?>
                                    <tr id="post-row-<?php echo htmlspecialchars($post['id']); ?>">
                                        <td><?php echo htmlspecialchars($post['title']); ?></td>
                                        <td><?php echo htmlspecialchars($post['category']); ?></td>
                                        <td><?php echo htmlspecialchars(date('d/m/Y', strtotime($post['date']))); ?></td>
                                        <td>
                                            <button class="btn btn-primary btn-sm edit-post-btn" data-id="<?php echo htmlspecialchars($post['id']); ?>"><i class="bi bi-pencil-square"></i></button>
                                            <button class="btn btn-danger btn-sm delete-post-btn" data-id="<?php echo htmlspecialchars($post['id']); ?>"><i class="bi bi-trash"></i></button>
                                        </td>
                                    </tr>
                                    <tr class="post-url-row">
                                        <td colspan="4" class="py-0">
                                            <small class="text-muted">URL: <a href="<?php echo $fullUrl; ?>" target="_blank"><?php echo htmlspecialchars($postUrl); ?></a></small>
                                            <button class="btn btn-link btn-sm copy-url-btn" data-url="<?php echo $fullUrl; ?>"><i class="bi bi-clipboard"></i></button>
                                        </td>
                                    </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
            <!-- 4. Descargas del Blog (Leads) -->
            <div class="tab-pane fade" id="descargas-blog-pane" role="tabpanel" aria-labelledby="descargas-blog-tab">
                <h4>Leads de Descargas del Blog</h4>
                <p>Contactos que han descargado archivos adjuntos de los artículos.</p>
                <div id="blog-download-feedback"></div>
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead>
                            <tr>
                                <th scope="col">Fecha</th>
                                <th scope="col">Nombre</th>
                                <th scope="col">Email</th>
                                <th scope="col">Archivo Descargado</th>
                                <th scope="col">Desde Artículo</th>
                                <th scope="col">Acciones</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php if (empty($processedLeads)): ?>
                                <tr><td colspan="6" class="text-center py-4">No hay registros de descargas.</td></tr>
                            <?php else: ?>
                                <?php foreach ($processedLeads as $lead): ?>
                                <tr id="lead-row-<?php echo htmlspecialchars($lead['id']); ?>">
                                    <td><?php echo htmlspecialchars(date('d/m/Y H:i', strtotime($lead['date']))); ?></td>
                                    <td><?php echo htmlspecialchars($lead['name']); ?></td>
                                    <td><a href="mailto:<?php echo htmlspecialchars($lead['email']); ?>"><?php echo htmlspecialchars($lead['email']); ?></a></td>
                                    <td><?php echo htmlspecialchars($lead['downloaded_file']); ?></td>
                                    <td><?php echo htmlspecialchars($lead['post_title']); ?></td>
                                    <td>
                                        <button class="btn btn-danger btn-sm delete-lead-btn" data-id="<?php echo htmlspecialchars($lead['id']); ?>"><i class="bi bi-trash"></i></button>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <!-- 5. Leads del Formulario de CRM/ERP -->
            <div class="tab-pane fade" id="leads-crm-pane" role="tabpanel" aria-labelledby="leads-crm-tab">
                <h4>Solicitudes de Demo (Página Dolibarr)</h4>
                <div class="d-flex justify-content-end mb-3">
                    <a href="export_crm_leads.php" class="btn btn-success"><i class="bi bi-file-earmark-spreadsheet-fill me-2"></i>Exportar a CSV</a>
                </div>
                <div id="crm-lead-feedback"></div>
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead>
                            <tr>
                                <th scope="col">Fecha</th>
                                <th scope="col">Nombre</th>
                                <th scope="col">Email</th>
                                <th scope="col">Empresa</th>
                                <th scope="col">Rubro</th>
                                <th scope="col">Acciones</th>
                            </tr>
                        </thead>
                        <tbody id="crm-leads-list">
                            <?php if (empty($crmLeads)): ?>
                                <tr><td colspan="6" class="text-center py-4">No hay solicitudes de demo.</td></tr>
                            <?php else: ?>
                                <?php foreach ($crmLeads as $lead): // El estado 'read' se usa para la campana, no para ocultar ?>
                                <tr id="crmlead-row-<?php echo htmlspecialchars($lead['id']); ?>">
                                    <td><?php echo htmlspecialchars(date('d/m/Y H:i', strtotime($lead['date']))); ?></td>
                                    <td><?php echo htmlspecialchars($lead['name']); ?></td>
                                    <td><a href="mailto:<?php echo htmlspecialchars($lead['email']); ?>"><?php echo htmlspecialchars($lead['email']); ?></a></td>
                                    <td><?php echo htmlspecialchars($lead['company']); ?></td>
                                    <td><?php echo htmlspecialchars($lead['sector']); ?></td>
                                    <td>
                                        <button class="btn btn-info btn-sm view-message-btn" data-bs-toggle="modal" data-bs-target="#contactModal" data-name="<?php echo htmlspecialchars($lead['name']); ?>" data-email="<?php echo htmlspecialchars($lead['email']); ?>" data-phone="" data-subject="Solicitud de Demo Dolibarr" data-date="<?php echo htmlspecialchars(date('d/m/Y H:i', strtotime($lead['date']))); ?>" data-message="<?php echo htmlspecialchars($lead['message']); ?>"><i class="bi bi-envelope-open"></i> Ver</button>
                                        <button class="btn btn-danger btn-sm delete-crmlead-btn" data-id="<?php echo htmlspecialchars($lead['id']); ?>"><i class="bi bi-trash"></i></button>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>
            <!-- 6. Leads de Nextcloud -->
            <div class="tab-pane fade" id="leads-nextcloud-pane" role="tabpanel" aria-labelledby="leads-nextcloud-tab">
                <h4>Solicitudes de Demo (Página Nextcloud)</h4>
                <div class="d-flex justify-content-end mb-3">
                    <a href="export_nextcloud_leads.php" class="btn btn-success"><i class="bi bi-file-earmark-spreadsheet-fill me-2"></i>Exportar a CSV</a>
                </div>
                <div id="nextcloud-lead-feedback"></div>
                <div class="table-responsive">
                    <table class="table table-striped table-hover">
                        <thead>
                            <tr>
                                <th scope="col">Fecha</th>
                                <th scope="col">Nombre</th>
                                <th scope="col">Email</th>
                                <th scope="col">Empresa</th>
                                <th scope="col">Acciones</th>
                            </tr>
                        </thead>
                        <tbody id="nextcloud-leads-list">
                            <?php if (empty($nextcloudLeads)): ?>
                                <tr><td colspan="5" class="text-center py-4">No hay solicitudes de demo para Nextcloud.</td></tr>
                            <?php else: ?>
                                <?php foreach ($nextcloudLeads as $lead): ?>
                                <tr id="nclead-row-<?php echo htmlspecialchars($lead['id']); ?>">
                                    <td><?php echo htmlspecialchars(date('d/m/Y H:i', strtotime($lead['date']))); ?></td>
                                    <td><?php echo htmlspecialchars($lead['name']); ?></td>
                                    <td><a href="mailto:<?php echo htmlspecialchars($lead['email']); ?>"><?php echo htmlspecialchars($lead['email']); ?></a></td>
                                    <td><?php echo htmlspecialchars($lead['company']); ?></td>
                                    <td>
                                        <button class="btn btn-info btn-sm view-message-btn" data-bs-toggle="modal" data-bs-target="#contactModal" data-name="<?php echo htmlspecialchars($lead['name']); ?>" data-email="<?php echo htmlspecialchars($lead['email']); ?>" data-phone="" data-subject="Solicitud de Demo Nextcloud" data-date="<?php echo htmlspecialchars(date('d/m/Y H:i', strtotime($lead['date']))); ?>" data-message="<?php echo htmlspecialchars($lead['message']); ?>"><i class="bi bi-envelope-open"></i> Ver</button>
                                        <button class="btn btn-danger btn-sm delete-nextcloudlead-btn" data-id="<?php echo htmlspecialchars($lead['id']); ?>"><i class="bi bi-trash"></i></button>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            <?php endif; ?>
                        </tbody>
                    </table>
                </div>
            </div>


        </div>
    </main>

    <!-- Modal para ver mensaje de contacto -->
    <div class="modal fade" id="contactModal" tabindex="-1" aria-labelledby="contactModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-lg">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="contactModalLabel">Detalle del Mensaje</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <p><strong>De:</strong> <span id="modal-contact-name"></span></p>
            <p><strong>Contacto:</strong> <a href="#" id="modal-contact-email"></a> | <span id="modal-contact-phone"></span></p>
            <p><strong>Fecha:</strong> <span id="modal-contact-date"></span></p>
            <p><strong>Asunto:</strong> <span id="modal-contact-subject"></span></p>
            <hr>
            <p id="modal-contact-message" style="white-space: pre-wrap;"></p>
          </div>
          <div class="modal-footer">
            <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cerrar</button>
          </div>
        </div>
      </div>
    </div>

    <!-- Modal para EDITAR artículo del blog -->
    <div class="modal fade" id="editPostModal" tabindex="-1" aria-labelledby="editPostModalLabel" aria-hidden="true">
      <div class="modal-dialog modal-lg">
        <div class="modal-content">
          <div class="modal-header">
            <h5 class="modal-title" id="editPostModalLabel">Editar Artículo</h5>
            <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
          </div>
          <div class="modal-body">
            <form id="edit-post-form">
                <input type="hidden" id="edit-post-id" name="id">
                <div class="mb-3">
                    <label for="edit-post-title" class="form-label">Título</label>
                    <input type="text" class="form-control" id="edit-post-title" name="title" required>
                </div>
                <div class="mb-3">
                    <label for="edit-post-subtitle" class="form-label">Subtítulo</label>
                    <input type="text" class="form-control" id="edit-post-subtitle" name="subtitle" required>
                </div>
                <div class="mb-3">
                    <label for="edit-post-image" class="form-label">Cambiar Imagen Principal (opcional)</label>
                    <input class="form-control" type="file" id="edit-post-image" name="image" accept="image/jpeg, image/png, image/webp">
                    <div class="form-text">Dejar en blanco para conservar la imagen actual.</div>
                </div>
                <div class="mb-3">
                    <label for="edit-post-category" class="form-label">Categoría</label>
                    <input type="text" class="form-control" id="edit-post-category" name="category" required>
                </div>
                <div class="mb-3">
                    <label for="edit-post-content" class="form-label">Contenido</label>
                    <textarea class="form-control" id="edit-post-content" name="content" rows="10" required aria-describedby="editContentHelp"></textarea>
                    <div id="editContentHelp" class="form-text">Puedes usar etiquetas HTML para dar formato al texto.</div>
                </div>
                <div class="mb-3">
                    <label class="form-label">Archivos Adjuntos Actuales</label>
                    <div id="edit-current-attachments"></div>
                </div>
                <div class="mb-3">
                    <label for="edit-post-attachments" class="form-label">Añadir Nuevos Adjuntos (opcional)</label>
                    <input class="form-control" type="file" id="edit-post-attachments" name="attachments[]" multiple>
                </div>
                <div id="edit-post-feedback" class="mt-3"></div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Cancelar</button>
                    <button type="submit" class="btn btn-primary">Guardar Cambios</button>
                </div>
            </form>
          </div>
        </div>
      </div>
    </div>

    <!-- Bootstrap JS Bundle -->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>

    <!-- Custom Admin JS -->
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const createUserForm = document.getElementById('create-user-form');
            const userFeedback = document.getElementById('user-feedback');
            const userList = document.getElementById('user-list');

            // --- Crear Usuario ---
            createUserForm.addEventListener('submit', function(e) {
                e.preventDefault();
                const name = document.getElementById('new-name').value;
                const email = document.getElementById('new-email').value;
                const username = document.getElementById('new-username').value;
                const password = document.getElementById('new-password').value;
                userFeedback.innerHTML = '';

                fetch('api.php', {
                    method: 'POST',
                    headers: {'Content-Type': 'application/json'},
                    body: JSON.stringify({ action: 'createUser', name, email, username, password })
                })
                .then(response => response.json())
                .then(data => {
                    userFeedback.className = data.success ? 'alert alert-success' : 'alert alert-danger';
                    userFeedback.textContent = data.message;
                    if (data.success) {
                        createUserForm.reset();
                        // Recargar la página para ver al nuevo usuario en la lista
                        setTimeout(() => window.location.reload(), 1500);
                    }
                })
                .catch(err => {
                    userFeedback.className = 'alert alert-danger';
                    userFeedback.textContent = 'Error de conexión con el servidor.';
                });
            });

            // --- Eliminar Lead de CRM ---
            document.getElementById('leads-crm-pane').addEventListener('click', function(e) {
                if (e.target && e.target.closest('.delete-crmlead-btn')) {
                    const button = e.target.closest('.delete-crmlead-btn');
                    const leadId = button.dataset.id;
                    const feedbackDiv = document.getElementById('crm-lead-feedback');

                    if (confirm('¿Estás seguro de que quieres eliminar esta solicitud?')) {
                        feedbackDiv.innerHTML = '';

                        fetch('api.php', {
                            method: 'POST',
                            headers: {'Content-Type': 'application/json'},
                            body: JSON.stringify({ action: 'deleteCrmLead', id: leadId })
                        })
                        .then(response => response.json())
                        .then(data => {
                            feedbackDiv.className = data.success ? 'alert alert-success' : 'alert alert-danger';
                            feedbackDiv.textContent = data.message;
                            if (data.success) {
                                document.getElementById('crmlead-row-' + leadId).remove();
                            }
                        })
                        .catch(err => {
                            feedbackDiv.className = 'alert alert-danger';
                            feedbackDiv.textContent = 'Error de conexión con el servidor.';
                        });
                    }
                }
            });
            // --- Eliminar Usuario ---
            userList.addEventListener('click', function(e) {
                if (e.target && e.target.closest('.delete-user-btn')) {
                    const button = e.target.closest('.delete-user-btn');
                    const row = button.closest('tr');
                    const username = row.dataset.username;

                    if (confirm(`¿Estás seguro de que quieres eliminar al usuario "${username}"?`)) {
                        userFeedback.innerHTML = '';

                        fetch('api.php', {
                            method: 'POST',
                            headers: {'Content-Type': 'application/json'},
                            body: JSON.stringify({ action: 'deleteUser', username })
                        })
                        .then(response => response.json())
                        .then(data => {
                            userFeedback.className = data.success ? 'alert alert-success' : 'alert alert-danger';
                            userFeedback.textContent = data.message;
                            if (data.success) {
                                row.remove();
                            }
                        })
                        .catch(err => {
                            userFeedback.className = 'alert alert-danger';
                            userFeedback.textContent = 'Error de conexión con el servidor.';
                        });
                    }
                }
            });

            // --- Eliminar Mensaje de Contacto ---
            document.getElementById('listado-contactos-pane').addEventListener('click', function(e) {
                if (e.target && e.target.closest('.delete-contact-btn')) {
                    const button = e.target.closest('.delete-contact-btn');
                    const contactId = button.dataset.id;
                    const feedbackDiv = document.getElementById('contact-list-feedback');

                    if (confirm('¿Estás seguro de que quieres eliminar este mensaje? Esta acción no se puede deshacer.')) {
                        feedbackDiv.innerHTML = '';

                        fetch('api.php', {
                            method: 'POST',
                            headers: {'Content-Type': 'application/json'},
                            body: JSON.stringify({ action: 'deleteContact', id: contactId })
                        })
                        .then(response => response.json())
                        .then(data => {
                            feedbackDiv.className = data.success ? 'alert alert-success' : 'alert alert-danger';
                            feedbackDiv.textContent = data.message;
                            if (data.success) {
                                document.getElementById('contact-row-' + contactId).remove();
                            }
                        })
                        .catch(err => {
                            feedbackDiv.className = 'alert alert-danger';
                            feedbackDiv.textContent = 'Error de conexión con el servidor.';
                        });
                    }
                }
            });

            // --- Ver Mensaje de Contacto en Modal ---
            const contactModal = document.getElementById('contactModal');
            contactModal.addEventListener('show.bs.modal', function (event) {
                // Botón que activó el modal
                const button = event.relatedTarget;

                // Extraer información de los atributos data-*
                const name = button.getAttribute('data-name');
                const email = button.getAttribute('data-email');
                const phone = button.getAttribute('data-phone');
                const subject = button.getAttribute('data-subject');
                const date = button.getAttribute('data-date');
                const message = button.getAttribute('data-message');

                // Actualizar el contenido del modal
                contactModal.querySelector('#modal-contact-name').textContent = name;
                contactModal.querySelector('#modal-contact-phone').textContent = phone;
                contactModal.querySelector('#modal-contact-email').textContent = email;
                contactModal.querySelector('#modal-contact-email').href = 'mailto:' + email;
                contactModal.querySelector('#modal-contact-date').textContent = date;
                contactModal.querySelector('#modal-contact-subject').textContent = subject;
                contactModal.querySelector('#modal-contact-message').textContent = message;
            });

            // --- Crear Artículo del Blog ---
            const createPostForm = document.getElementById('create-blog-post-form');
            const postFeedback = document.getElementById('blog-post-feedback');

            createPostForm.addEventListener('submit', function(e) {
                e.preventDefault();
                postFeedback.innerHTML = '';

                const formData = new FormData(createPostForm);
                formData.append('action', 'createBlogPost');

                fetch('api.php', {
                    method: 'POST',
                    body: formData // No se establece Content-Type, el navegador lo hace por nosotros
                })
                .then(response => response.json())
                .then(data => {
                    postFeedback.className = data.success ? 'alert alert-success' : 'alert alert-danger';
                    postFeedback.textContent = data.message;
                    if (data.success) {
                        createPostForm.reset();
                        setTimeout(() => window.location.reload(), 1500);
                    }
                })
                .catch(err => {
                    postFeedback.className = 'alert alert-danger';
                    postFeedback.textContent = 'Error de conexión con el servidor.';
                });
            });

            // --- Eliminar Artículo del Blog ---
            document.getElementById('cargar-blog-pane').addEventListener('click', function(e) {
                if (e.target && e.target.closest('.delete-post-btn')) {
                    const button = e.target.closest('.delete-post-btn');
                    const postId = button.dataset.id;

                    if (confirm('¿Estás seguro de que quieres eliminar este artículo?')) {
                        postFeedback.innerHTML = '';

                        fetch('api.php', {
                            method: 'POST',
                            headers: {'Content-Type': 'application/json'},
                            body: JSON.stringify({ action: 'deleteBlogPost', id: postId })
                        })
                        .then(response => response.json())
                        .then(data => {
                            postFeedback.className = data.success ? 'alert alert-success' : 'alert alert-danger';
                            postFeedback.textContent = data.message;
                            if (data.success) {
                                const postRow = document.getElementById('post-row-' + postId);
                                if (postRow) {
                                    // Eliminar también la fila siguiente que contiene la URL
                                    const urlRow = postRow.nextElementSibling;
                                    if (urlRow && urlRow.classList.contains('post-url-row')) {
                                        urlRow.remove();
                                    }
                                    postRow.remove();
                                }
                            }
                        })
                        .catch(err => {
                            postFeedback.className = 'alert alert-danger';
                            postFeedback.textContent = 'Error de conexión con el servidor.';
                        });
                    }
                }
            });

            // --- Copiar URL del post al portapapeles ---
            document.getElementById('cargar-blog-pane').addEventListener('click', function(e) {
                const button = e.target.closest('.copy-url-btn');
                if (button) {
                    const urlToCopy = button.dataset.url;
                    navigator.clipboard.writeText(urlToCopy).then(() => {
                        // Opcional: mostrar feedback visual
                        const icon = button.querySelector('i');
                        icon.classList.remove('bi-clipboard');
                        icon.classList.add('bi-clipboard-check-fill');
                        setTimeout(() => {
                            icon.classList.remove('bi-clipboard-check-fill');
                            icon.classList.add('bi-clipboard');
                        }, 2000);
                    });
                }
            });

            // --- Editar Artículo del Blog ---
            const editPostModal = new bootstrap.Modal(document.getElementById('editPostModal'));
            const editPostForm = document.getElementById('edit-post-form');
            const editPostFeedback = document.getElementById('edit-post-feedback');

            document.getElementById('cargar-blog-pane').addEventListener('click', function(e) {
                if (e.target.closest('.edit-post-btn')) {
                    const button = e.target.closest('.edit-post-btn');
                    const postId = button.dataset.id;
                    editPostFeedback.innerHTML = '';

                    // 1. Obtener los datos completos del post desde la API
                    fetch('api.php', {
                        method: 'POST',
                        headers: {'Content-Type': 'application/json'},
                        body: JSON.stringify({ action: 'getPostDetails', id: postId })
                    })
                    .then(res => res.json())
                    .then(data => {
                        if (data.success) {
                            const post = data.post;
                            // 2. Poblar el formulario del modal
                            document.getElementById('edit-post-id').value = post.id;
                            document.getElementById('edit-post-title').value = post.title;
                            document.getElementById('edit-post-subtitle').value = post.subtitle;
                            document.getElementById('edit-post-category').value = post.category;
                            document.getElementById('edit-post-content').value = post.content; // Contenido en Markdown

                            // Poblar lista de adjuntos actuales
                            const attachmentsContainer = document.getElementById('edit-current-attachments');
                            attachmentsContainer.innerHTML = '';
                            if (post.attachments && post.attachments.length > 0) {
                                post.attachments.forEach(file => {
                                    attachmentsContainer.innerHTML += `
                                        <div class="form-check">
                                            <input class="form-check-input" type="checkbox" name="delete_attachments[]" value="${file.path}" id="del-attach-${file.path.replace(/[^a-zA-Z0-9]/g, "")}">
                                            <label class="form-check-label" for="del-attach-${file.path.replace(/[^a-zA-Z0-9]/g, "")}">
                                                Eliminar: ${file.filename}
                                            </label>
                                        </div>
                                    `;
                                });
                            } else {
                                attachmentsContainer.innerHTML = '<p class="form-text">No hay archivos adjuntos.</p>';
                            }

                            // 3. Mostrar el modal
                            editPostModal.show();
                        } else {
                            alert('Error: ' + data.message);
                        }
                    });
                }
            });

            // Enviar el formulario de edición
            editPostForm.addEventListener('submit', function(e) {
                e.preventDefault();
                editPostFeedback.innerHTML = '';
                const formData = new FormData(editPostForm);
                formData.append('action', 'updateBlogPost');

                fetch('api.php', {
                    method: 'POST',
                    body: formData
                })
                .then(res => res.json())
                .then(data => {
                    editPostFeedback.className = data.success ? 'alert alert-success' : 'alert alert-danger';
                    editPostFeedback.textContent = data.message;
                    if (data.success) {
                        setTimeout(() => {
                            editPostModal.hide();
                            window.location.reload();
                        }, 1500);
                    }
                })
                .catch(err => {
                    editPostFeedback.className = 'alert alert-danger';
                    editPostFeedback.textContent = 'Error de conexión con el servidor.';
                });
            });

            // --- Marcar Notificaciones como Leídas ---
            const notificationDropdown = document.getElementById('notificationDropdown');
            const notificationBadge = document.querySelector('.notification-badge');
            let notificationsMarked = false; // Para evitar llamadas múltiples

            notificationDropdown.addEventListener('click', function() {
                // Solo ejecutar si hay notificaciones y no se han marcado ya
                if (notificationBadge && !notificationsMarked) {
                    fetch('api.php', {
                        method: 'POST',
                        headers: {'Content-Type': 'application/json'},
                        body: JSON.stringify({ action: 'markNotificationsAsRead' })
                    })
                    .then(response => response.json())
                    .then(data => {
                        if (data.success) {
                            // Ocultar el punto rojo inmediatamente
                            notificationBadge.style.display = 'none';
                            notificationsMarked = true; // Marcar como hecho
                        }
                    })
                    .catch(err => {
                        console.error('Error al marcar notificaciones como leídas:', err);
                    });
                }
            });

            // --- Eliminar Lead de Nextcloud ---
            document.getElementById('leads-nextcloud-pane').addEventListener('click', function(e) {
                if (e.target && e.target.closest('.delete-nextcloudlead-btn')) {
                    const button = e.target.closest('.delete-nextcloudlead-btn');
                    const leadId = button.dataset.id;
                    const feedbackDiv = document.getElementById('nextcloud-lead-feedback');

                    if (confirm('¿Estás seguro de que quieres eliminar esta solicitud de Nextcloud?')) {
                        feedbackDiv.innerHTML = '';

                        fetch('api.php', {
                            method: 'POST',
                            headers: {'Content-Type': 'application/json'},
                            body: JSON.stringify({ action: 'deleteNextcloudLead', id: leadId })
                        })
                        .then(response => response.json())
                        .then(data => {
                            feedbackDiv.className = data.success ? 'alert alert-success' : 'alert alert-danger';
                            feedbackDiv.textContent = data.message;
                            if (data.success) {
                                document.getElementById('nclead-row-' + leadId).remove();
                            }
                        })
                        .catch(err => {
                            feedbackDiv.className = 'alert alert-danger';
                            feedbackDiv.textContent = 'Error de conexión con el servidor.';
                        });
                    }
                }
            });

            // --- Eliminar Lead de Descarga del Blog ---
            document.getElementById('descargas-blog-pane').addEventListener('click', function(e) {
                if (e.target && e.target.closest('.delete-lead-btn')) {
                    const button = e.target.closest('.delete-lead-btn');
                    const leadId = button.dataset.id;
                    const feedbackDiv = document.getElementById('blog-download-feedback');

                    if (confirm('¿Estás seguro de que quieres eliminar este registro de descarga?')) {
                        feedbackDiv.innerHTML = '';

                        fetch('api.php', {
                            method: 'POST',
                            headers: {'Content-Type': 'application/json'},
                            body: JSON.stringify({ action: 'deleteBlogLead', id: leadId })
                        })
                        .then(response => response.json())
                        .then(data => {
                            feedbackDiv.className = data.success ? 'alert alert-success' : 'alert alert-danger';
                            feedbackDiv.textContent = data.message;
                            if (data.success) {
                                document.getElementById('lead-row-' + leadId).remove();
                            }
                        })
                        .catch(err => {
                            feedbackDiv.className = 'alert alert-danger';
                            feedbackDiv.textContent = 'Error de conexión con el servidor.';
                        });
                    }
                }
            });



        });
    </script>
</body>
</html>