<?php
// lead_handler.php

header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405);
    echo json_encode(['success' => false, 'message' => 'Método no permitido.']);
    exit;
}

$input = json_decode(file_get_contents('php://input'), true);

$name = trim($input['name'] ?? '');
$email = trim($input['email'] ?? '');
$filePath = $input['filePath'] ?? '';

if (empty($name) || empty($email) || empty($filePath)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Nombre, email y archivo son requeridos.']);
    exit;
}

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Email no válido.']);
    exit;
}

// --- Seguridad: Validar la ruta del archivo ---
// Asegurarse de que el archivo está en el directorio de adjuntos esperado
$baseDir = __DIR__ . '/uploads/blog/attachments/';
$realBasePath = realpath($baseDir);
$realFilePath = realpath(__DIR__ . '/' . $filePath);

if ($realFilePath === false || strpos($realFilePath, $realBasePath) !== 0) {
    http_response_code(403);
    echo json_encode(['success' => false, 'message' => 'Acceso denegado al archivo.']);
    exit;
}

// --- Enviar notificación por correo ---
$to = "oscarmorinigo@dunamis.com.py, contacto@dunamis.com.py, didierluckmann@dunamis.com.py";
$email_subject = "Nuevo Lead por Descarga desde el Blog";
$email_body = "Un usuario ha descargado un archivo desde el blog.\n\n" .
              "Detalles del Lead:\n" .
              "--------------------------------------------------\n" .
              "Nombre: $name\n" .
              "Email: $email\n" .
              "Archivo Descargado: " . basename($filePath) . "\n" .
              "--------------------------------------------------\n";
$headers = "From: no-reply@dunamis.com.py\r\n" .
           "Reply-To: $email";

@mail($to, $email_subject, $email_body, $headers);

// --- Guardar el Lead ---
$db_file = 'db.json';
if (file_exists($db_file)) {
    $db = json_decode(file_get_contents($db_file), true);
    
    // Creamos la sección si no existe
    if (!isset($db['leads'])) {
        $db['leads'] = [];
    }

    $newLead = [
        'id' => 'lead_' . uniqid(),
        'date' => date('Y-m-d H:i:s'),
        'name' => $name,
        'email' => $email,
        'downloaded_file' => basename($filePath)
    ];
    array_unshift($db['leads'], $newLead);

    file_put_contents($db_file, json_encode($db, JSON_PRETTY_PRINT));
}

// --- Generar un enlace de descarga temporal y seguro (opcional pero recomendado) ---
// Por simplicidad, aquí solo confirmamos que se puede descargar.
// En una implementación más robusta, se generaría un token de un solo uso.

echo json_encode([
    'success' => true, 
    'message' => 'Datos guardados. Iniciando descarga...',
    'downloadUrl' => $filePath // Enviamos la URL para que el JS la abra
]);