<?php
// export_crm_leads.php
session_start();

// 1. Verificar autenticación
if (!isset($_SESSION['user_logged_in']) || $_SESSION['user_logged_in'] !== true) {
    header("HTTP/1.1 403 Forbidden");
    echo "Acceso denegado. Por favor, inicie sesión.";
    exit;
}

// 2. Cargar los datos
$db_file = 'db.json';
$crmLeads = [];
if (file_exists($db_file)) {
    $json_data = file_get_contents($db_file);
    $db = json_decode($json_data, true);
    $crmLeads = $db['crmLeads'] ?? [];
}

// 3. Configurar cabeceras para la descarga del CSV
$filename = "dunamis_crm_leads_" . date('Y-m-d') . ".csv";
header('Content-Type: text/csv; charset=utf-8');
header('Content-Disposition: attachment; filename="' . $filename . '"');

// 4. Abrir el flujo de salida de PHP para escribir el CSV
$output = fopen('php://output', 'w');

// 5. Escribir la fila de encabezados del CSV
fputcsv($output, [
    'Fecha',
    'Nombre',
    'Email',
    'Empresa',
    'Rubro',
    'Mensaje'
]);

// 6. Escribir los datos de cada lead en el CSV
foreach ($crmLeads as $lead) {
    fputcsv($output, [
        $lead['date'] ?? '',
        $lead['name'] ?? '',
        $lead['email'] ?? '',
        $lead['company'] ?? '',
        $lead['sector'] ?? '',
        $lead['message'] ?? ''
    ]);
}

// 7. Cerrar el flujo y terminar el script
fclose($output);
exit;