<?php
// crm_lead_handler.php

// Establecer la cabecera para devolver JSON
header('Content-Type: application/json');

// Solo permitir peticiones POST
if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    http_response_code(405); // Method Not Allowed
    echo json_encode(['success' => false, 'message' => 'Método no permitido.']);
    exit;
}

// Obtener los datos enviados en el cuerpo de la petición
$input = json_decode(file_get_contents('php://input'), true);

// Validar datos
$name = trim($input['nombre'] ?? '');
$email = trim($input['email'] ?? '');
$company = trim($input['empresa'] ?? '');
$sector = trim($input['rubro'] ?? '');
$message = trim($input['mensaje'] ?? '');

if (empty($name) || empty($email) || empty($company) || empty($sector)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Por favor, complete todos los campos requeridos.']);
    exit;
}

if (!filter_var($email, FILTER_VALIDATE_EMAIL)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Por favor, ingrese una dirección de correo electrónico válida.']);
    exit;
}

// --- Enviar notificación por correo ---
$to = "oscarmorinigo@dunamis.com.py, contacto@dunamis.com.py, didierluckmann@dunamis.com.py";
$email_subject = "Nueva Solicitud de Demo Dolibarr (CRM/ERP)";
$email_body = "Has recibido una nueva solicitud de demo para Dolibarr desde la landing page.\n\n" .
              "Detalles del Lead:\n" .
              "--------------------------------------------------\n" .
              "Nombre: $name\n" .
              "Email: $email\n" .
              "Empresa: $company\n" .
              "Rubro: $sector\n\n" .
              "Mensaje:\n$message\n" .
              "--------------------------------------------------\n";
$headers = "From: no-reply@dunamis.com.py\r\n" .
           "Reply-To: $email";

@mail($to, $email_subject, $email_body, $headers);

// Cargar la base de datos
$db_file = 'db.json';
if (!file_exists($db_file) || !is_writable($db_file)) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Error del servidor: no se puede acceder a la base de datos.']);
    exit;
}

// Cargar la base de datos de forma segura
$db_template = ['users' => [], 'contacts' => [], 'blogPosts' => [], 'leads' => [], 'crmLeads' => [], 'nextcloudLeads' => []];
$db = $db_template; // Empezar con la plantilla por defecto

$json_data = file_get_contents($db_file);
if (!empty(trim($json_data))) { // Solo procesar si el archivo no está vacío
    $decoded_db = json_decode($json_data, true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        http_response_code(500);
        echo json_encode(['success' => false, 'message' => 'Error del servidor: la base de datos parece estar corrupta.']);
        exit;
    }

    // Si el JSON es válido, lo fusionamos con la plantilla para asegurar que todas las claves existan.
    if (is_array($decoded_db)) {
        $db = array_merge($db_template, $decoded_db);
    }
}

// Crear el nuevo lead
$new_lead = [
    'id' => 'crmlead_' . uniqid(),
    'date' => date('Y-m-d H:i:s'),
    'name' => $name,
    'email' => $email,
    'company' => $company,
    'sector' => $sector,
    'message' => $message
];

// Añadir el nuevo lead al principio del array
array_unshift($db['crmLeads'], $new_lead);

// Guardar en la base de datos
file_put_contents($db_file, json_encode($db, JSON_PRETTY_PRINT | JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE));

echo json_encode(['success' => true, 'message' => '¡Solicitud enviada con éxito! Nos pondremos en contacto con usted pronto.']);