<?php
header('Content-Type: application/json');

// Directorio donde se guardarán las imágenes.
$uploadDir = 'uploads/';

// Asegurarse de que el directorio de subida exista. Si no, intentar crearlo.
if (!is_dir($uploadDir)) {
    if (!mkdir($uploadDir, 0755, true)) {
        echo json_encode(['status' => 'error', 'message' => 'Error: No se pudo crear el directorio de subida.']);
        exit;
    }
}

// Verificar si se recibió un archivo y si es el que esperamos ('heroImage').
if (isset($_FILES['heroImage']) && $_FILES['heroImage']['error'] === UPLOAD_ERR_OK) {
    $file = $_FILES['heroImage'];
    $fileName = $file['name'];
    $fileTmpName = $file['tmp_name'];
    $fileSize = $file['size'];
    $fileError = $file['error'];

    // Obtener la extensión del archivo.
    $fileExt = strtolower(pathinfo($fileName, PATHINFO_EXTENSION));

    // Lista de extensiones permitidas.
    $allowed = ['jpg', 'jpeg', 'png', 'gif', 'webp'];

    if (in_array($fileExt, $allowed)) {
        // Limitar el tamaño del archivo (ej: 5MB).
        if ($fileSize < 5000000) {
            // Crear un nombre de archivo único para evitar sobreescribir archivos existentes.
            // Se usa el prefijo 'hero_' seguido de un id único y la extensión original.
            $newFileName = 'hero_' . uniqid('', true) . '.' . $fileExt;
            $fileDestination = $uploadDir . $newFileName;

            // Mover el archivo desde la ubicación temporal a la definitiva.
            if (move_uploaded_file($fileTmpName, $fileDestination)) {
                // Si todo fue bien, devolver la ruta del archivo para guardarla en la BD.
                echo json_encode(['status' => 'success', 'message' => 'Imagen subida correctamente.', 'filePath' => $fileDestination]);
            } else {
                echo json_encode(['status' => 'error', 'message' => 'Error al mover el archivo subido.']);
            }
        } else {
            echo json_encode(['status' => 'error', 'message' => 'El archivo es demasiado grande. El límite es 5MB.']);
        }
    } else {
        echo json_encode(['status' => 'error', 'message' => 'Tipo de archivo no permitido. Sube imágenes JPG, PNG, GIF o WEBP.']);
    }
} else {
    // Si no se subió ningún archivo o hubo un error en la subida.
    $errorMessage = isset($_FILES['heroImage']['error']) ? 'Error de subida código: ' . $_FILES['heroImage']['error'] : 'No se recibió ningún archivo.';
    echo json_encode(['status' => 'error', 'message' => $errorMessage]);
}
?>