<?php
/**
 * Script de verificación de rutas de módulos
 * Ejecutar desde línea de comandos: php tests/verify_routes.php
 */

// Definir módulos esperados
$modules = [
    'usuarios', 
    'casos', 
    'clientes', 
    'agenda', 
    'tareas',
    'chat', 
    'facturacion', 
    'compras', 
    'proveedores',
    'contabilidad', 
    'rrhh', 
    'ia', 
    'biblioteca',
    'reportes', 
    'archivos', 
    'configuracion', 
    'permisos',
    'contenido_web' // Este aún no está creado, debería fallar o marcarse como pendiente
];

$baseDir = dirname(__DIR__) . '/modules';
$errors = 0;

echo "========================================\n";
echo "VERIFICACIÓN DE RUTAS DE MÓDULOS LEXIPRO\n";
echo "========================================\n\n";

foreach ($modules as $module) {
    $modulePath = $baseDir . '/' . $module;
    $indexPath = $modulePath . '/index.php';
    $apiPath = $modulePath . '/api.php';
    
    echo str_pad("Módulo: $module", 30, ".");
    
    if (!is_dir($modulePath)) {
        echo " [FALTA DIRECTORIO]\n";
        $errors++;
        continue;
    }
    
    $status = [];
    if (file_exists($indexPath)) {
        $status[] = "Index: OK";
    } else {
        $status[] = "Index: FALTA";
        $errors++;
    }
    
    if (file_exists($apiPath)) {
        $status[] = "API: OK";
    } else {
        $status[] = "API: FALTA";
        $errors++; // Algunos módulos podrían no tener API, pero por ahora asumimos que sí
    }
    
    echo " " . implode(", ", $status) . "\n";
}

echo "\n========================================\n";
if ($errors > 0) {
    echo "RESULTADO: SE ENCONTRARON $errors ERRORES\n";
} else {
    echo "RESULTADO: TODO CORRECTO\n";
}
echo "========================================\n";
