<?php
/**
 * LexiPro - API de Reportes
 */

session_start();
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';
require_once '../../config/database.php';

header('Content-Type: application/json; charset=utf-8');

$auth = new Auth();
$auth->requireLogin();

$db = Database::getInstance();
$userId = $_SESSION['user_id'];
$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    $auth->requirePermission('reportes', 'ver');
    
    $action = $_GET['action'] ?? 'dashboard';
    $year = $_GET['year'] ?? date('Y');
    
    if ($action === 'dashboard') {
        // 1. Ingresos vs Gastos (Últimos 12 meses)
        $ingresos = [];
        $gastos = [];
        $meses = [];
        
        for ($i = 1; $i <= 12; $i++) {
            $meses[] = date('M', mktime(0, 0, 0, $i, 1));
            
            // Ingresos (Facturas cobradas)
            $ingreso = $db->fetchOne("
                SELECT SUM(total) as total 
                FROM facturas 
                WHERE YEAR(fecha_emision) = ? AND MONTH(fecha_emision) = ? AND estado = 'pagada'
            ", [$year, $i]);
            $ingresos[] = (float)($ingreso['total'] ?? 0);
            
            // Gastos (Compras pagadas)
            $gasto = $db->fetchOne("
                SELECT SUM(total) as total 
                FROM compras 
                WHERE YEAR(fecha_emision) = ? AND MONTH(fecha_emision) = ? AND estado = 'pagada'
            ", [$year, $i]);
            $gastos[] = (float)($gasto['total'] ?? 0);
        }
        
        // 2. Estado de Casos
        $casos_estado = $db->fetchAll("
            SELECT estado, COUNT(*) as total 
            FROM casos 
            GROUP BY estado
        ");
        
        // 3. Top Clientes
        $top_clientes = $db->fetchAll("
            SELECT c.nombre, c.apellido, SUM(f.total) as total_facturado
            FROM facturas f
            JOIN clientes c ON f.cliente_id = c.id
            WHERE f.estado = 'pagada' AND YEAR(f.fecha_emision) = ?
            GROUP BY c.id
            ORDER BY total_facturado DESC
            LIMIT 5
        ", [$year]);
        
        // 4. KPIs Generales
        $total_ingresos = array_sum($ingresos);
        $total_gastos = array_sum($gastos);
        $beneficio = $total_ingresos - $total_gastos;
        $casos_nuevos = $db->fetchOne("SELECT COUNT(*) as c FROM casos WHERE YEAR(fecha_inicio) = ?", [$year])['c'];
        
        jsonSuccess([
            'chart_finance' => [
                'labels' => $meses,
                'ingresos' => $ingresos,
                'gastos' => $gastos
            ],
            'chart_casos' => $casos_estado,
            'top_clientes' => $top_clientes,
            'kpis' => [
                'ingresos' => $total_ingresos,
                'gastos' => $total_gastos,
                'beneficio' => $beneficio,
                'casos_nuevos' => $casos_nuevos
            ]
        ]);
    }
}
