<?php
require_once '../../config/database.php';

$db = Database::getInstance();

// Crear tabla de notificaciones
$sql = "CREATE TABLE IF NOT EXISTS notificaciones (
    id INT AUTO_INCREMENT PRIMARY KEY,
    usuario_id INT NOT NULL,
    tipo ENUM('info', 'success', 'warning', 'danger') DEFAULT 'info',
    titulo VARCHAR(100) NOT NULL,
    mensaje TEXT,
    enlace VARCHAR(255),
    leido TINYINT(1) DEFAULT 0,
    fecha_creacion DATETIME DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (usuario_id) REFERENCES usuarios(id)
)";

$db->query($sql);

echo "Tabla de notificaciones creada correctamente.";
