<?php
/**
 * LexiPro - API de Notificaciones
 */

session_start();
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';
require_once '../../config/database.php';

header('Content-Type: application/json; charset=utf-8');

$auth = new Auth();
$auth->requireLogin();

$db = Database::getInstance();
$userId = $_SESSION['user_id'];
$method = $_SERVER['REQUEST_METHOD'];

// GET - Obtener notificaciones
if ($method === 'GET') {
    $action = $_GET['action'] ?? 'unread';
    
    if ($action === 'unread') {
        // Obtener conteo
        $count = $db->fetchOne("SELECT COUNT(*) as c FROM notificaciones WHERE usuario_id = ? AND leido = 0", [$userId]);
        
        // Obtener últimas 10 no leídas (o recientes si hay pocas)
        $notificaciones = $db->fetchAll("SELECT * FROM notificaciones WHERE usuario_id = ? ORDER BY leido ASC, fecha_creacion DESC LIMIT 10", [$userId]);
        
        jsonSuccess([
            'count' => $count['c'],
            'items' => $notificaciones
        ]);
    }
}

// POST - Marcar como leída
elseif ($method === 'POST') {
    $action = $_POST['action'] ?? '';
    
    if ($action === 'mark_read') {
        $id = $_POST['id'] ?? 0;
        
        if ($id == 'all') {
            $db->update('notificaciones', ['leido' => 1], "usuario_id = $userId");
        } else {
            $db->update('notificaciones', ['leido' => 1], "id = $id AND usuario_id = $userId");
        }
        
        jsonSuccess([], 'Notificación marcada como leída');
    }
    
    // Endpoint interno para crear notificación (útil para pruebas o llamadas AJAX desde otros módulos)
    elseif ($action === 'create_test') {
        // Solo para admin o pruebas
        crearNotificacion($userId, 'Prueba de Sistema', 'Esta es una notificación de prueba.', 'info');
        jsonSuccess([], 'Notificación creada');
    }
}
