<?php
/**
 * LexiPro - API de Inteligencia Artificial
 */

session_start();
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';
require_once '../../config/database.php';
require_once 'gemini_client.php';
require_once 'prompts.php';

header('Content-Type: application/json; charset=utf-8');

$auth = new Auth();
$auth->requireLogin();

$db = Database::getInstance();
$userId = $_SESSION['user_id'];
$method = $_SERVER['REQUEST_METHOD'];

try {
    $client = new GeminiClient();
    
    if (!$client->isConfigured()) {
        jsonError('La API Key de Gemini no está configurada. Ve a Configuración > Inteligencia Artificial.');
    }

    // POST - Generar contenido
    if ($method === 'POST') {
        $auth->requirePermission('ia', 'crear');
        
        $data = json_decode(file_get_contents('php://input'), true);
        $action = $data['action'] ?? 'chat';
        
        if ($action === 'chat') {
            $message = $data['message'] ?? '';
            $history = $data['history'] ?? [];
            
            if (empty($message)) {
                jsonError('El mensaje no puede estar vacío');
            }
            
            try {
                $response = $client->generateContent($message, $history);
                
                // Guardar log de uso (opcional)
                // $db->insert('ia_logs', ...);
                
                jsonSuccess(['response' => $response]);
            } catch (Exception $e) {
                jsonError($e->getMessage());
            }
        }
        
        elseif ($action === 'generate_document') {
            $type = $data['type'] ?? '';
            $context = $data['context'] ?? '';
            
            $prompts = PromptManager::getPrompts();
            $basePrompt = $prompts[$type]['template'] ?? '';
            
            if (empty($basePrompt)) {
                jsonError('Tipo de documento no válido');
            }
            
            // Reemplazar variables en el prompt si es necesario
            $finalPrompt = "Instrucción: $basePrompt\n\nContexto del caso:\n$context";
            
            try {
                $response = $client->generateContent($finalPrompt);
                jsonSuccess(['content' => $response]);
            } catch (Exception $e) {
                jsonError($e->getMessage());
            }
        }
        
        elseif ($action === 'analyze_text') {
            $text = $data['text'] ?? '';
            
            if (empty($text)) {
                jsonError('No hay texto para analizar');
            }
            
            $prompt = "Analiza el siguiente texto jurídico. Identifica: 1) Puntos clave, 2) Fechas importantes, 3) Riesgos potenciales, 4) Sugerencias de acción.\n\nTexto:\n$text";
            
            try {
                $response = $client->generateContent($prompt);
                jsonSuccess(['analysis' => $response]);
            } catch (Exception $e) {
                jsonError($e->getMessage());
            }
        }
    }
    
} catch (Exception $e) {
    error_log("Error en API IA: " . $e->getMessage());
    jsonError('Error del servidor: ' . $e->getMessage(), 500);
}
