<?php
/**
 * LexiPro - Estado de Resultados
 */

session_start();
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';
require_once '../../config/database.php';

$auth = new Auth();
$auth->requireLogin();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Estado de Resultados - LexiPro</title>
    <link rel="stylesheet" href="../../assets/css/lexipro.css">
    <style>
        .result-card {
            background: white;
            border-radius: 8px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            padding: 30px;
            max-width: 800px;
            margin: 0 auto;
        }
        
        .section-title {
            font-size: 18px;
            font-weight: 700;
            margin-bottom: 15px;
            padding-bottom: 10px;
            border-bottom: 2px solid #e5e7eb;
        }
        
        .account-row {
            display: flex;
            justify-content: space-between;
            padding: 10px 0;
            border-bottom: 1px solid #f3f4f6;
        }
        
        .subtotal-row {
            display: flex;
            justify-content: space-between;
            padding: 15px 0;
            font-weight: 700;
            background: #f9fafb;
            margin: 10px -30px;
            padding-left: 30px;
            padding-right: 30px;
        }
        
        .final-result {
            margin-top: 30px;
            padding: 20px;
            border-radius: 8px;
            text-align: center;
            font-size: 24px;
            font-weight: 700;
        }
        
        .result-positive { background: #d1fae5; color: #059669; }
        .result-negative { background: #fee2e2; color: #dc2626; }
    </style>
</head>
<body>
    <?php include '../../includes/header.php'; ?>
    
    <div class="container">
        <div class="header-flex">
            <div>
                <h1>💰 Estado de Resultados</h1>
                <p>Pérdidas y Ganancias del período</p>
            </div>
            <button class="btn btn-secondary" onclick="window.print()">Imprimir</button>
        </div>
        
        <div class="filters" style="justify-content: center;">
            <div class="filter-group">
                <label>Desde</label>
                <input type="date" id="fechaDesde" value="<?= date('Y-m-01') ?>">
            </div>
            <div class="filter-group">
                <label>Hasta</label>
                <input type="date" id="fechaHasta" value="<?= date('Y-m-t') ?>">
            </div>
            <div class="filter-group" style="align-self: flex-end;">
                <button class="btn btn-primary" onclick="loadResultados()">Generar</button>
            </div>
        </div>
        
        <div id="loading" class="loading">Calculando resultados...</div>
        
        <div id="resultContent" style="display: none;">
            <div class="result-card">
                <!-- INGRESOS -->
                <div class="section-title" style="color: #059669;">INGRESOS OPERATIVOS</div>
                <div id="ingresosList"></div>
                <div class="subtotal-row">
                    <span>TOTAL INGRESOS</span>
                    <span id="totalIngresos">Gs. 0</span>
                </div>
                
                <!-- EGRESOS -->
                <div class="section-title" style="color: #dc2626; margin-top: 30px;">EGRESOS OPERATIVOS</div>
                <div id="egresosList"></div>
                <div class="subtotal-row">
                    <span>TOTAL EGRESOS</span>
                    <span id="totalEgresos">Gs. 0</span>
                </div>
                
                <!-- RESULTADO FINAL -->
                <div id="finalResultBox" class="final-result">
                    <div style="font-size: 14px; margin-bottom: 5px; opacity: 0.8;">RESULTADO DEL EJERCICIO</div>
                    <span id="resultadoFinal">Gs. 0</span>
                </div>
            </div>
        </div>
    </div>

    <script src="../../assets/js/lexipro.js"></script>
    <script>
        async function loadResultados() {
            const desde = document.getElementById('fechaDesde').value;
            const hasta = document.getElementById('fechaHasta').value;
            
            document.getElementById('resultContent').style.display = 'none';
            document.getElementById('loading').style.display = 'block';
            
            try {
                const response = await fetch(`api.php?action=resultados&fecha_desde=${desde}&fecha_hasta=${hasta}`);
                const data = await response.json();
                
                if (data.success) {
                    renderResultados(data);
                }
            } catch (error) {
                console.error(error);
                alert('Error al cargar resultados');
            } finally {
                document.getElementById('loading').style.display = 'none';
            }
        }
        
        function renderResultados(data) {
            document.getElementById('resultContent').style.display = 'block';
            
            // Ingresos
            renderList('ingresosList', data.ingresos);
            document.getElementById('totalIngresos').textContent = LexiPro.formatMoney(data.total_ingresos);
            
            // Egresos
            renderList('egresosList', data.egresos);
            document.getElementById('totalEgresos').textContent = LexiPro.formatMoney(data.total_egresos);
            
            // Resultado Final
            const utilidad = parseFloat(data.utilidad);
            const box = document.getElementById('finalResultBox');
            const label = document.getElementById('resultadoFinal');
            
            label.textContent = LexiPro.formatMoney(utilidad);
            
            if (utilidad >= 0) {
                box.className = 'final-result result-positive';
                box.innerHTML = `<div style="font-size: 14px; margin-bottom: 5px;">UTILIDAD DEL EJERCICIO</div>${LexiPro.formatMoney(utilidad)}`;
            } else {
                box.className = 'final-result result-negative';
                box.innerHTML = `<div style="font-size: 14px; margin-bottom: 5px;">PÉRDIDA DEL EJERCICIO</div>${LexiPro.formatMoney(utilidad)}`;
            }
        }
        
        function renderList(elementId, items) {
            const container = document.getElementById(elementId);
            if (items.length === 0) {
                container.innerHTML = '<div style="text-align: center; color: #9ca3af; padding: 10px;">Sin movimientos</div>';
                return;
            }
            
            container.innerHTML = items.map(item => `
                <div class="account-row">
                    <div>
                        <span style="color: #6b7280; margin-right: 10px;">${item.codigo}</span>
                        <span>${item.nombre}</span>
                    </div>
                    <strong>${LexiPro.formatMoney(item.monto)}</strong>
                </div>
            `).join('');
        }
        
        // Iniciar
        loadResultados();
    </script>
</body>
</html>
