<?php
/**
 * LexiPro - Plan de Cuentas
 */

session_start();
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';
require_once '../../config/database.php';

$auth = new Auth();
$auth->requireLogin();
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Plan de Cuentas - LexiPro</title>
    <link rel="stylesheet" href="../../assets/css/lexipro.css">
    <style>
        .tree-view {
            background: white;
            border-radius: 8px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            padding: 20px;
        }
        
        .tree-item {
            padding: 8px 10px;
            border-bottom: 1px solid #f3f4f6;
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        
        .tree-item:hover {
            background-color: #f9fafb;
        }
        
        .level-1 { font-weight: 700; font-size: 16px; background: #f3f4f6; margin-top: 10px; }
        .level-2 { font-weight: 600; padding-left: 30px; }
        .level-3 { padding-left: 60px; color: #4b5563; }
        .level-4 { padding-left: 90px; color: #6b7280; font-size: 14px; }
        
        .badge-type {
            font-size: 11px;
            padding: 2px 6px;
            border-radius: 4px;
            text-transform: uppercase;
        }
        
        .type-activo { background: #d1fae5; color: #065f46; }
        .type-pasivo { background: #fee2e2; color: #991b1b; }
        .type-patrimonio { background: #dbeafe; color: #1e40af; }
        .type-ingreso { background: #fef3c7; color: #92400e; }
        .type-egreso { background: #f3f4f6; color: #374151; }
    </style>
</head>
<body>
    <?php include '../../includes/header.php'; ?>
    
    <div class="container">
        <div class="header-flex">
            <div>
                <h1>🗂️ Plan de Cuentas</h1>
                <p>Catálogo de cuentas contables</p>
            </div>
            <!-- Futura implementación: Agregar cuenta -->
            <!-- <button class="btn btn-primary">+ Nueva Cuenta</button> -->
        </div>
        
        <div class="tree-view" id="planCuentasContainer">
            <div class="loading">Cargando plan de cuentas...</div>
        </div>
    </div>

    <script src="../../assets/js/lexipro.js"></script>
    <script>
        async function loadPlanCuentas() {
            try {
                const response = await fetch('api.php?action=plan_cuentas');
                const data = await response.json();
                
                if (data.success) {
                    renderPlanCuentas(data.cuentas);
                }
            } catch (error) {
                console.error(error);
                document.getElementById('planCuentasContainer').innerHTML = '<div class="alert alert-danger">Error al cargar datos</div>';
            }
        }
        
        function renderPlanCuentas(cuentas) {
            const container = document.getElementById('planCuentasContainer');
            
            if (cuentas.length === 0) {
                container.innerHTML = '<p>No hay cuentas configuradas.</p>';
                return;
            }
            
            container.innerHTML = cuentas.map(c => {
                // Determinar nivel basado en puntos en el código (1, 1.1, 1.1.1)
                const level = c.codigo.split('.').length;
                const levelClass = `level-${Math.min(level, 4)}`;
                
                return `
                    <div class="tree-item ${levelClass}">
                        <div>
                            <span style="font-family: monospace; margin-right: 10px;">${c.codigo}</span>
                            <span>${c.nombre}</span>
                        </div>
                        <div style="display: flex; gap: 10px; align-items: center;">
                            <span class="badge-type type-${c.tipo}">${c.tipo}</span>
                            ${c.es_movimiento == 1 ? '<span style="font-size: 10px; color: #6b7280;">(Movimiento)</span>' : ''}
                        </div>
                    </div>
                `;
            }).join('');
        }
        
        loadPlanCuentas();
    </script>
</body>
</html>
