<?php
/**
 * LexiPro - Libro Mayor
 */

session_start();
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';
require_once '../../config/database.php';

$auth = new Auth();
$auth->requireLogin();

$db = Database::getInstance();

// Obtener cuentas para el selector
$cuentas = $db->fetchAll("SELECT * FROM plan_cuentas WHERE es_movimiento = 1 ORDER BY codigo");
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Libro Mayor - LexiPro</title>
    <link rel="stylesheet" href="../../assets/css/lexipro.css">
    <style>
        .mayor-header {
            background: white;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 1px 3px rgba(0,0,0,0.1);
            margin-bottom: 20px;
        }
        
        .saldo-card {
            background: linear-gradient(135deg, #3b82f6 0%, #2563eb 100%);
            color: white;
            padding: 20px;
            border-radius: 8px;
            text-align: center;
            margin-bottom: 20px;
        }
        
        .saldo-amount {
            font-size: 32px;
            font-weight: 700;
        }
    </style>
</head>
<body>
    <?php include '../../includes/header.php'; ?>
    
    <div class="container">
        <div class="header-flex">
            <div>
                <h1>📋 Libro Mayor</h1>
                <p>Movimientos detallados por cuenta contable</p>
            </div>
            <button class="btn btn-secondary" onclick="window.print()">Imprimir</button>
        </div>
        
        <div class="mayor-header">
            <div class="filters" style="margin-bottom: 0;">
                <div class="filter-group" style="flex: 2;">
                    <label>Seleccionar Cuenta</label>
                    <select id="cuentaSelector" onchange="loadMayor()">
                        <option value="">Seleccione una cuenta...</option>
                        <?php foreach ($cuentas as $c): ?>
                            <option value="<?= $c['id'] ?>"><?= $c['codigo'] ?> - <?= $c['nombre'] ?></option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="filter-group">
                    <label>Desde</label>
                    <input type="date" id="fechaDesde" value="<?= date('Y-01-01') ?>" onchange="loadMayor()">
                </div>
                <div class="filter-group">
                    <label>Hasta</label>
                    <input type="date" id="fechaHasta" value="<?= date('Y-m-t') ?>" onchange="loadMayor()">
                </div>
            </div>
        </div>
        
        <div id="mayorContent" style="display: none;">
            <div class="saldo-card">
                <div style="opacity: 0.9; margin-bottom: 5px;">Saldo Actual</div>
                <div class="saldo-amount" id="saldoActual">Gs. 0</div>
            </div>
            
            <div class="table-container">
                <table>
                    <thead>
                        <tr>
                            <th>Fecha</th>
                            <th>Asiento</th>
                            <th>Descripción</th>
                            <th style="text-align: right;">Debe</th>
                            <th style="text-align: right;">Haber</th>
                            <th style="text-align: right;">Saldo Acumulado</th>
                        </tr>
                    </thead>
                    <tbody id="mayorBody">
                        <!-- Filas dinámicas -->
                    </tbody>
                </table>
            </div>
        </div>
        
        <div id="emptyState" style="text-align: center; padding: 50px; color: #6b7280;">
            <h3>Seleccione una cuenta para ver sus movimientos</h3>
        </div>
    </div>

    <script src="../../assets/js/lexipro.js"></script>
    <script>
        async function loadMayor() {
            const cuentaId = document.getElementById('cuentaSelector').value;
            const desde = document.getElementById('fechaDesde').value;
            const hasta = document.getElementById('fechaHasta').value;
            
            if (!cuentaId) {
                document.getElementById('mayorContent').style.display = 'none';
                document.getElementById('emptyState').style.display = 'block';
                return;
            }
            
            document.getElementById('mayorContent').style.display = 'block';
            document.getElementById('emptyState').style.display = 'none';
            const tbody = document.getElementById('mayorBody');
            tbody.innerHTML = '<tr><td colspan="6" class="loading">Cargando...</td></tr>';
            
            try {
                const response = await fetch(`api.php?action=mayor&cuenta_id=${cuentaId}&fecha_desde=${desde}&fecha_hasta=${hasta}`);
                const data = await response.json();
                
                if (data.success) {
                    renderMayor(data.movimientos);
                }
            } catch (error) {
                console.error(error);
            }
        }
        
        function renderMayor(movimientos) {
            const tbody = document.getElementById('mayorBody');
            
            if (movimientos.length === 0) {
                tbody.innerHTML = '<tr><td colspan="6" style="text-align: center; padding: 20px;">No hay movimientos en este período</td></tr>';
                document.getElementById('saldoActual').textContent = 'Gs. 0';
                return;
            }
            
            let ultimoSaldo = 0;
            
            tbody.innerHTML = movimientos.map(m => {
                ultimoSaldo = parseFloat(m.saldo);
                return `
                    <tr>
                        <td>${LexiPro.formatDate(m.fecha)}</td>
                        <td>${m.descripcion}</td>
                        <td>${m.detalle_desc || '-'}</td>
                        <td style="text-align: right;">${parseFloat(m.debe) > 0 ? LexiPro.formatMoney(m.debe) : '-'}</td>
                        <td style="text-align: right;">${parseFloat(m.haber) > 0 ? LexiPro.formatMoney(m.haber) : '-'}</td>
                        <td style="text-align: right; font-weight: bold;">${LexiPro.formatMoney(m.saldo)}</td>
                    </tr>
                `;
            }).join('');
            
            document.getElementById('saldoActual').textContent = LexiPro.formatMoney(ultimoSaldo);
        }
    </script>
</body>
</html>
