<?php
/**
 * LexiPro - Dashboard de Contabilidad
 */

session_start();
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';
require_once '../../includes/contabilidad_functions.php';
require_once '../../config/database.php';

$auth = new Auth();
$auth->requireLogin();

$db = Database::getInstance();
$currentUser = $auth->getCurrentUser();

// Breadcrumbs
$breadcrumbs = [
    ['label' => 'Contabilidad']
];

// Obtener estadísticas del mes
$mesActual = date('Y-m');
$fechaDesde = $mesActual . '-01';
$fechaHasta = date('Y-m-t');

$resultados = getEstadoResultados($fechaDesde, $fechaHasta);
$balance = getBalance();

// Contar asientos del mes
$asientosMes = $db->fetchOne(
    "SELECT COUNT(*) as total FROM asientos_contables WHERE fecha BETWEEN ? AND ?",
    [$fechaDesde, $fechaHasta]
);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contabilidad - LexiPro</title>
    <link rel="stylesheet" href="../../assets/css/lexipro.css">
    <style>
        .accounting-header {
            background: linear-gradient(135deg, #059669 0%, #10b981 100%);
            color: white;
            padding: 30px;
            border-radius: 12px 12px 0 0;
            margin-bottom: 0;
        }
        
        .accounting-stats {
            display: grid;
            grid-template-columns: repeat(4, 1fr);
            gap: 20px;
            margin-bottom: 20px;
        }
        
        .stat-box {
            background: white;
            padding: 20px;
            border-radius: 8px;
            text-align: center;
        }
        
        .stat-value {
            font-size: 28px;
            font-weight: 700;
            margin-bottom: 5px;
        }
        
        .stat-value.positive { color: #059669; }
        .stat-value.negative { color: #dc2626; }
        .stat-value.neutral { color: #6b7280; }
        
        .stat-label {
            font-size: 13px;
            color: #6b7280;
        }
        
        .report-cards {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 20px;
            margin-top: 20px;
        }
        
        .report-card {
            background: white;
            padding: 25px;
            border-radius: 12px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .report-card:hover {
            box-shadow: 0 4px 16px rgba(0,0,0,0.1);
            transform: translateY(-2px);
        }
        
        .report-card h3 {
            margin-bottom: 10px;
            color: #1f2937;
        }
        
        .report-card p {
            color: #6b7280;
            font-size: 14px;
        }
        
        .report-icon {
            font-size: 40px;
            margin-bottom: 15px;
        }
    </style>
</head>
<body>
    <?php include '../../includes/header.php'; ?>
    
    <div class="container">
        <div class="accounting-header">
            <div style="display: flex; justify-content: space-between; align-items: center;">
                <div>
                    <h1>📊 Contabilidad</h1>
                    <p style="opacity: 0.9; margin-top: 5px;">Sistema contable completo</p>
                </div>
                <button class="btn btn-primary" onclick="window.location.href='asientos.php'" style="background: white; color: #059669;">
                    + Nuevo Asiento
                </button>
            </div>
        </div>
        
        <div class="accounting-stats">
            <div class="stat-box">
                <div class="stat-value positive"><?= formatMoney($resultados['total_ingresos']) ?></div>
                <div class="stat-label">Ingresos del Mes</div>
            </div>
            <div class="stat-box">
                <div class="stat-value negative"><?= formatMoney($resultados['total_egresos']) ?></div>
                <div class="stat-label">Egresos del Mes</div>
            </div>
            <div class="stat-box">
                <div class="stat-value <?= $resultados['utilidad'] >= 0 ? 'positive' : 'negative' ?>">
                    <?= formatMoney($resultados['utilidad']) ?>
                </div>
                <div class="stat-label"><?= $resultados['utilidad'] >= 0 ? 'Utilidad' : 'Pérdida' ?> del Mes</div>
            </div>
            <div class="stat-box">
                <div class="stat-value neutral"><?= $asientosMes['total'] ?></div>
                <div class="stat-label">Asientos del Mes</div>
            </div>
        </div>
        
        <div class="alert" style="background: #dbeafe; border-left: 4px solid #3b82f6; padding: 15px; border-radius: 8px; margin-bottom: 20px;">
            <strong>ℹ️ Sistema Contable Activo:</strong> Los asientos se generan automáticamente desde facturas de venta y compra. 
            También puedes crear asientos manuales desde el Libro Diario.
        </div>
        
        <h2 style="margin-bottom: 20px;">Reportes Contables</h2>
        
        <div class="report-cards">
            <div class="report-card" onclick="window.location.href='asientos.php'">
                <div class="report-icon">📖</div>
                <h3>Libro Diario</h3>
                <p>Registro cronológico de todos los asientos contables</p>
            </div>
            
            <div class="report-card" onclick="window.location.href='mayor.php'">
                <div class="report-icon">📋</div>
                <h3>Libro Mayor</h3>
                <p>Movimientos detallados por cuenta contable</p>
            </div>
            
            <div class="report-card" onclick="window.location.href='balance.php'">
                <div class="report-icon">⚖️</div>
                <h3>Balance General</h3>
                <p>Situación patrimonial a una fecha determinada</p>
            </div>
            
            <div class="report-card" onclick="window.location.href='resultados.php'">
                <div class="report-icon">💰</div>
                <h3>Estado de Resultados</h3>
                <p>Ingresos y egresos de un período</p>
            </div>
            
            <div class="report-card" onclick="window.location.href='plan_cuentas.php'">
                <div class="report-icon">🗂️</div>
                <h3>Plan de Cuentas</h3>
                <p>Gestión del catálogo de cuentas contables</p>
            </div>
            
            <div class="report-card" onclick="alert('Próximamente: Flujo de Efectivo')">
                <div class="report-icon">💵</div>
                <h3>Flujo de Efectivo</h3>
                <p>Movimientos de caja y bancos</p>
            </div>
        </div>
        
        <div style="margin-top: 30px; background: white; padding: 25px; border-radius: 12px;">
            <h3 style="margin-bottom: 15px;">Resumen del Balance</h3>
            <div style="display: grid; grid-template-columns: 1fr 1fr; gap: 30px;">
                <div>
                    <h4 style="color: #059669; margin-bottom: 10px;">ACTIVO</h4>
                    <div style="font-size: 24px; font-weight: 700; color: #059669;">
                        <?= formatMoney($balance['total_activo']) ?>
                    </div>
                </div>
                <div>
                    <h4 style="color: #dc2626; margin-bottom: 10px;">PASIVO + PATRIMONIO</h4>
                    <div style="font-size: 24px; font-weight: 700; color: #dc2626;">
                        <?= formatMoney($balance['total_pasivo'] + $balance['total_patrimonio']) ?>
                    </div>
                </div>
            </div>
            
            <?php
            $diferencia = abs($balance['total_activo'] - ($balance['total_pasivo'] + $balance['total_patrimonio']));
            if ($diferencia > 0.01):
            ?>
                <div class="alert" style="background: #fee2e2; border-left: 4px solid #dc2626; padding: 15px; border-radius: 8px; margin-top: 15px;">
                    <strong>⚠️ Advertencia:</strong> El balance no cuadra. Diferencia: <?= formatMoney($diferencia) ?>
                </div>
            <?php else: ?>
                <div class="alert" style="background: #d1fae5; border-left: 4px solid #059669; padding: 15px; border-radius: 8px; margin-top: 15px;">
                    <strong>✓ Balance Correcto:</strong> Activo = Pasivo + Patrimonio
                </div>
            <?php endif; ?>
        </div>
    </div>
    
    <script src="../../assets/js/lexipro.js"></script>
</body>
</html>
