<?php
/**
 * LexiPro - Configuración del Sistema
 */

session_start();
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';
require_once '../../config/database.php';

$auth = new Auth();
$auth->requireLogin();

$db = Database::getInstance();
$currentUser = $auth->getCurrentUser();

// Breadcrumbs
$breadcrumbs = [
    ['label' => 'Configuración']
];

// Obtener configuraciones actuales
$timbrado = $db->fetchOne("SELECT * FROM configuracion WHERE clave = 'timbrado_activo'");
$empresa = $db->fetchOne("SELECT * FROM configuracion WHERE clave = 'datos_empresa'");

$timbradoData = $timbrado ? json_decode($timbrado['valor'], true) : null;
$empresaData = $empresa ? json_decode($empresa['valor'], true) : null;
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Configuración - LexiPro</title>
    <link rel="stylesheet" href="../../assets/css/lexipro.css">
    <style>
        .config-tabs {
            display: flex;
            gap: 10px;
            margin-bottom: 20px;
            border-bottom: 2px solid #e5e7eb;
        }
        
        .config-tab {
            padding: 12px 24px;
            background: none;
            border: none;
            border-bottom: 3px solid transparent;
            cursor: pointer;
            font-weight: 600;
            color: #6b7280;
            transition: all 0.3s;
            margin-bottom: -2px;
        }
        
        .config-tab.active {
            color: var(--primary);
            border-bottom-color: var(--primary);
        }
        
        .config-section {
            display: none;
            background: white;
            padding: 30px;
            border-radius: 12px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
        }
        
        .config-section.active {
            display: block;
        }
        
        .config-group {
            margin-bottom: 30px;
            padding-bottom: 30px;
            border-bottom: 1px solid #e5e7eb;
        }
        
        .config-group:last-child {
            border-bottom: none;
        }
        
        .config-group h3 {
            margin-bottom: 15px;
            color: #1f2937;
        }
        
        .config-group p {
            color: #6b7280;
            font-size: 14px;
            margin-bottom: 20px;
        }
        
        .alert-info {
            background: #dbeafe;
            border-left: 4px solid #3b82f6;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        
        .alert-warning {
            background: #fef3c7;
            border-left: 4px solid #f59e0b;
            padding: 15px;
            border-radius: 8px;
            margin-bottom: 20px;
        }
        
        .logo-preview {
            max-width: 200px;
            max-height: 100px;
            margin-top: 10px;
            border: 2px solid #e5e7eb;
            border-radius: 8px;
            padding: 10px;
        }
    </style>
</head>
<body>
    <?php include '../../includes/header.php'; ?>
    
    <div class="container">
        <div class="header">
            <div>
                <h1>⚙️ Configuración del Sistema</h1>
                <p style="color: #6b7280; margin-top: 5px;">Gestiona los parámetros del sistema</p>
                    <h3>Información de la Empresa</h3>
                    <p>Datos que aparecerán en facturas y documentos oficiales</p>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label>Razón Social *</label>
                            <input type="text" name="razon_social" value="<?= e($empresaData['razon_social'] ?? '') ?>" required>
                        </div>
                        <div class="form-group">
                            <label>RUC *</label>
                            <input type="text" name="ruc" value="<?= e($empresaData['ruc'] ?? '') ?>" placeholder="80012345-6" required>
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label>Representante Legal</label>
                            <input type="text" name="representante" value="<?= e($empresaData['representante'] ?? '') ?>">
                        </div>
                        <div class="form-group">
                            <label>Teléfono</label>
                            <input type="text" name="telefono" value="<?= e($empresaData['telefono'] ?? '') ?>" placeholder="(021) 123-456">
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label>Dirección</label>
                        <textarea name="direccion" rows="2" style="width: 100%; padding: 12px; border: 2px solid #e5e7eb; border-radius: 8px;"><?= e($empresaData['direccion'] ?? '') ?></textarea>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label>Ciudad</label>
                            <input type="text" name="ciudad" value="<?= e($empresaData['ciudad'] ?? 'Asunción') ?>">
                        </div>
                        <div class="form-group">
                            <label>Email</label>
                            <input type="email" name="email" value="<?= e($empresaData['email'] ?? '') ?>">
                        </div>
                    </div>
                </div>
                
                <div class="config-group">
                    <h3>Logo de la Empresa</h3>
                    <p>Logo que aparecerá en facturas y documentos (formato PNG o JPG, máx. 2MB)</p>
                    
                    <input type="file" name="logo" accept="image/png,image/jpeg" id="logoInput">
                    
                    <?php if (!empty($empresaData['logo'])): ?>
                        <img src="<?= $empresaData['logo'] ?>" class="logo-preview" id="logoPreview">
                    <?php else: ?>
                        <img src="" class="logo-preview" id="logoPreview" style="display: none;">
                    <?php endif; ?>
                </div>
                
                <button type="submit" class="btn btn-primary" style="width: 100%;">
                    Guardar Datos de la Empresa
                </button>
            </form>
        </div>
        
        <!-- Configuración de Timbrado -->
        <div class="config-section" id="timbradoSection">
            <div class="alert-info">
                <strong>ℹ️ Información:</strong> El timbrado es obligatorio para facturar en Paraguay según la RG90. 
                Debe obtenerlo en la SET (Subsecretaría de Estado de Tributación).
            </div>
            
            <form id="timbradoForm">
                <div class="config-group">
                    <h3>Timbrado Activo</h3>
                    <p>Configure el timbrado que se utilizará para generar facturas</p>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label>Número de Timbrado *</label>
                            <input type="text" name="numero" value="<?= e($timbradoData['numero'] ?? '') ?>" placeholder="12345678" required maxlength="8">
                        </div>
                        <div class="form-group">
                            <label>Establecimiento *</label>
                            <input type="text" name="establecimiento" value="<?= e($timbradoData['establecimiento'] ?? '001') ?>" placeholder="001" required maxlength="3">
                        </div>
                        <div class="form-group">
                            <label>Punto de Expedición *</label>
                            <input type="text" name="punto_expedicion" value="<?= e($timbradoData['punto_expedicion'] ?? '001') ?>" placeholder="001" required maxlength="3">
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label>Fecha de Inicio *</label>
                            <input type="date" name="fecha_inicio" value="<?= e($timbradoData['fecha_inicio'] ?? '') ?>" required>
                        </div>
                        <div class="form-group">
                            <label>Fecha de Vencimiento *</label>
                            <input type="date" name="fecha_vencimiento" value="<?= e($timbradoData['fecha_vencimiento'] ?? '') ?>" required>
                        </div>
                    </div>
                    
                    <div class="form-row">
                        <div class="form-group">
                            <label>Número Inicial</label>
                            <input type="number" name="numero_inicial" value="<?= e($timbradoData['numero_inicial'] ?? '1') ?>" min="1">
                        </div>
                        <div class="form-group">
                            <label>Número Final</label>
                            <input type="number" name="numero_final" value="<?= e($timbradoData['numero_final'] ?? '999999') ?>" min="1">
                        </div>
                    </div>
                </div>
                
                <?php if ($timbradoData): ?>
                    <div class="alert-warning">
                        <strong>⚠️ Advertencia:</strong> Ya existe un timbrado configurado. 
                        Al guardar estos datos, se reemplazará el timbrado actual.
                    </div>
                <?php endif; ?>
                
                <button type="submit" class="btn btn-primary" style="width: 100%;">
                    Guardar Timbrado
                </button>
            </form>
        </div>
        
        <!-- Configuración del Sistema -->
        <div class="config-section" id="sistemaSection">
            <form id="sistemaForm">
                <div class="config-group">
                    <h3>Parámetros Generales</h3>
                    <p>Configuración general del sistema</p>
                    
                    <div class="form-group">
                        <label>Zona Horaria</label>
                        <select name="timezone" style="width: 100%; padding: 12px; border: 2px solid #e5e7eb; border-radius: 8px;">
                            <option value="America/Asuncion" selected>América/Asunción (Paraguay)</option>
                            <option value="America/Argentina/Buenos_Aires">América/Buenos Aires</option>
                            <option value="America/Sao_Paulo">América/São Paulo</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label>Moneda</label>
                        <select name="moneda" style="width: 100%; padding: 12px; border: 2px solid #e5e7eb; border-radius: 8px;">
                            <option value="PYG" selected>Guaraníes (Gs.)</option>
                            <option value="USD">Dólares (USD)</option>
                            <option value="EUR">Euros (EUR)</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label>
                            <input type="checkbox" name="modo_mantenimiento" value="1">
                            Modo Mantenimiento (solo administradores pueden acceder)
                        </label>
                    </div>
                </div>
                
                <div class="config-group">
                    <h3>Notificaciones</h3>
                    <p>Configure las notificaciones del sistema</p>
                    
                    <div class="form-group">
                        <label>
                            <input type="checkbox" name="notif_casos" value="1" checked>
                            Notificar asignación de casos
                        </label>
                    </div>
                    
                    <div class="form-group">
                        <label>
                            <input type="checkbox" name="notif_tareas" value="1" checked>
                            Notificar asignación de tareas
                        </label>
                    </div>
                    
                    <div class="form-group">
                        <label>
                            <input type="checkbox" name="notif_plazos" value="1" checked>
                            Notificar plazos jurídicos (a todo el equipo)
                        </label>
                    </div>
                    
                    <div class="form-group">
                        <label>
                            <input type="checkbox" name="notif_chat" value="1" checked>
                            Notificar mensajes de chat
                        </label>
                    </div>
                </div>
                
                <button type="submit" class="btn btn-primary" style="width: 100%;">
                    Guardar Configuración del Sistema
                </button>
            </form>
        </div>
    </div>
    
    <script src="../../assets/js/lexipro.js"></script>
    <script>
        // Cambiar tabs
        function switchTab(tab) {
            // Actualizar botones
            document.querySelectorAll('.config-tab').forEach(btn => btn.classList.remove('active'));
            event.target.classList.add('active');
            
            // Actualizar secciones
            document.querySelectorAll('.config-section').forEach(section => section.classList.remove('active'));
            document.getElementById(tab + 'Section').classList.add('active');
        }
        
        // Preview de logo
        document.getElementById('logoInput')?.addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const preview = document.getElementById('logoPreview');
                    preview.src = e.target.result;
                    preview.style.display = 'block';
                };
                reader.readAsDataURL(file);
            }
        });
        
        // Guardar datos de empresa
        document.getElementById('empresaForm').addEventListener('submit', async (e) => {
            e.preventDefault();
            
            const formData = new FormData(e.target);
            const data = {
                razon_social: formData.get('razon_social'),
                ruc: formData.get('ruc'),
                representante: formData.get('representante'),
                telefono: formData.get('telefono'),
                direccion: formData.get('direccion'),
                ciudad: formData.get('ciudad'),
                email: formData.get('email')
            };
            
            // TODO: Manejar upload de logo
            
            try {
                const response = await fetch('api.php', {
                    method: 'POST',
                    headers: {'Content-Type': 'application/json'},
                    body: JSON.stringify({
                        clave: 'datos_empresa',
                        valor: data,
                        tipo: 'json',
                        categoria: 'empresa',
                        descripcion: 'Datos de la empresa'
                    })
                });
                
                const result = await response.json();
                
                if (result.success) {
                    alert('Datos de la empresa guardados exitosamente');
                } else {
                    alert(result.error);
                }
            } catch (error) {
                alert('Error al guardar configuración');
                console.error(error);
            }
        });
        
        // Guardar timbrado
        document.getElementById('timbradoForm').addEventListener('submit', async (e) => {
            e.preventDefault();
            
            const formData = new FormData(e.target);
            const data = {
                numero: formData.get('numero'),
                establecimiento: formData.get('establecimiento'),
                punto_expedicion: formData.get('punto_expedicion'),
                fecha_inicio: formData.get('fecha_inicio'),
                fecha_vencimiento: formData.get('fecha_vencimiento'),
                numero_inicial: parseInt(formData.get('numero_inicial')),
                numero_final: parseInt(formData.get('numero_final'))
            };
            
            // Validar fechas
            const inicio = new Date(data.fecha_inicio);
            const vencimiento = new Date(data.fecha_vencimiento);
            
            if (vencimiento <= inicio) {
                alert('La fecha de vencimiento debe ser posterior a la fecha de inicio');
                return;
            }
            
            try {
                const response = await fetch('api.php', {
                    method: 'POST',
                    headers: {'Content-Type': 'application/json'},
                    body: JSON.stringify({
                        clave: 'timbrado_activo',
                        valor: data,
```
                        </div>
                        <div class="form-group">
                            <label>Número Final</label>
                            <input type="number" name="numero_final" value="<?= e($timbradoData['numero_final'] ?? '999999') ?>" min="1">
                        </div>
                    </div>
                </div>
                
                <?php if ($timbradoData): ?>
                    <div class="alert-warning">
                        <strong>⚠️ Advertencia:</strong> Ya existe un timbrado configurado. 
                        Al guardar estos datos, se reemplazará el timbrado actual.
                    </div>
                <?php endif; ?>
                
                <button type="submit" class="btn btn-primary" style="width: 100%;">
                    Guardar Timbrado
                </button>
            </form>
        </div>
        
        <!-- Configuración del Sistema -->
        <div class="config-section" id="sistemaSection">
            <form id="sistemaForm">
                <div class="config-group">
                    <h3>Parámetros Generales</h3>
                    <p>Configuración general del sistema</p>
                    
                    <div class="form-group">
                        <label>Zona Horaria</label>
                        <select name="timezone" style="width: 100%; padding: 12px; border: 2px solid #e5e7eb; border-radius: 8px;">
                            <option value="America/Asuncion" selected>América/Asunción (Paraguay)</option>
                            <option value="America/Argentina/Buenos_Aires">América/Buenos Aires</option>
                            <option value="America/Sao_Paulo">América/São Paulo</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label>Moneda</label>
                        <select name="moneda" style="width: 100%; padding: 12px; border: 2px solid #e5e7eb; border-radius: 8px;">
                            <option value="PYG" selected>Guaraníes (Gs.)</option>
                            <option value="USD">Dólares (USD)</option>
                            <option value="EUR">Euros (EUR)</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label>
                            <input type="checkbox" name="modo_mantenimiento" value="1">
                            Modo Mantenimiento (solo administradores pueden acceder)
                        </label>
                    </div>
                </div>
                
                <div class="config-group">
                    <h3>Notificaciones</h3>
                    <p>Configure las notificaciones del sistema</p>
                    
                    <div class="form-group">
                        <label>
                            <input type="checkbox" name="notif_casos" value="1" checked>
                            Notificar asignación de casos
                        </label>
                    </div>
                    
                    <div class="form-group">
                        <label>
                            <input type="checkbox" name="notif_tareas" value="1" checked>
                            Notificar asignación de tareas
                        </label>
                    </div>
                    
                    <div class="form-group">
                        <label>
                            <input type="checkbox" name="notif_plazos" value="1" checked>
                            Notificar plazos jurídicos (a todo el equipo)
                        </label>
                    </div>
                    
                    <div class="form-group">
                        <label>
                            <input type="checkbox" name="notif_chat" value="1" checked>
                            Notificar mensajes de chat
                        </label>
                    </div>
                </div>
                
                <button type="submit" class="btn btn-primary" style="width: 100%;">
                    Guardar Configuración del Sistema
                </button>
            </form>
        </div>
    </div>
    
    <script src="../../assets/js/lexipro.js"></script>
    <script>
        // Cambiar tabs
        function switchTab(tab) {
            // Actualizar botones
            document.querySelectorAll('.config-tab').forEach(btn => btn.classList.remove('active'));
            event.target.classList.add('active');
            
            // Actualizar secciones
            document.querySelectorAll('.config-section').forEach(section => section.classList.remove('active'));
            document.getElementById(tab + 'Section').classList.add('active');
        }
        
        // Preview de logo
        document.getElementById('logoInput')?.addEventListener('change', function(e) {
            const file = e.target.files[0];
            if (file) {
                const reader = new FileReader();
                reader.onload = function(e) {
                    const preview = document.getElementById('logoPreview');
                    preview.src = e.target.result;
                    preview.style.display = 'block';
                };
                reader.readAsDataURL(file);
            }
        });
        
        // Guardar datos de empresa
        document.getElementById('empresaForm').addEventListener('submit', async (e) => {
            e.preventDefault();
            
            const formData = new FormData(e.target);
            const data = {
                razon_social: formData.get('razon_social'),
                ruc: formData.get('ruc'),
                representante: formData.get('representante'),
                telefono: formData.get('telefono'),
                direccion: formData.get('direccion'),
                ciudad: formData.get('ciudad'),
                email: formData.get('email')
            };
            
            // TODO: Manejar upload de logo
            
            try {
                const response = await fetch('api.php', {
                    method: 'POST',
                    headers: {'Content-Type': 'application/json'},
                    body: JSON.stringify({
                        clave: 'datos_empresa',
                        valor: data,
                        tipo: 'json',
                        categoria: 'empresa',
                        descripcion: 'Datos de la empresa'
                    })
                });
                
                const result = await response.json();
                
                if (result.success) {
                    alert('Datos de la empresa guardados exitosamente');
                } else {
                    alert(result.error);
                }
            } catch (error) {
                alert('Error al guardar configuración');
                console.error(error);
            }
        });
        
        // Guardar timbrado
        document.getElementById('timbradoForm').addEventListener('submit', async (e) => {
            e.preventDefault();
            
            const formData = new FormData(e.target);
            const data = {
                numero: formData.get('numero'),
                establecimiento: formData.get('establecimiento'),
                punto_expedicion: formData.get('punto_expedicion'),
                fecha_inicio: formData.get('fecha_inicio'),
                fecha_vencimiento: formData.get('fecha_vencimiento'),
                numero_inicial: parseInt(formData.get('numero_inicial')),
                numero_final: parseInt(formData.get('numero_final'))
            };
            
            // Validar fechas
            const inicio = new Date(data.fecha_inicio);
            const vencimiento = new Date(data.fecha_vencimiento);
            
            if (vencimiento <= inicio) {
                alert('La fecha de vencimiento debe ser posterior a la fecha de inicio');
                return;
            }
            
            try {
                const response = await fetch('api.php', {
                    method: 'POST',
                    headers: {'Content-Type': 'application/json'},
                    body: JSON.stringify({
                        clave: 'timbrado_activo',
                        valor: data,
                        tipo: 'json',
                        categoria: 'facturacion',
                        descripcion: 'Timbrado activo para facturación'
                    })
                });
                
                const result = await response.json();
                
                if (result.success) {
                    alert('Timbrado guardado exitosamente. Ya puede generar facturas.');
                } else {
                    alert(result.error);
                }
            } catch (error) {
                alert('Error al guardar configuración');
                console.error(error);
            }
        });
        
        // Guardar configuración del sistema
        document.getElementById('sistemaForm').addEventListener('submit', async (e) => {
            e.preventDefault();
            
            const formData = new FormData(e.target);
            const data = {
                timezone: formData.get('timezone'),
                moneda: formData.get('moneda'),
                modo_mantenimiento: formData.get('modo_mantenimiento') ? 1 : 0,
                notif_casos: formData.get('notif_casos') ? 1 : 0,
                notif_tareas: formData.get('notif_tareas') ? 1 : 0,
                notif_plazos: formData.get('notif_plazos') ? 1 : 0,
                notif_chat: formData.get('notif_chat') ? 1 : 0
            };
            
            try {
                const response = await fetch('api.php', {
                    method: 'POST',
                    headers: {'Content-Type': 'application/json'},
                    body: JSON.stringify({
                        clave: 'sistema_general',
                        valor: data,
                        tipo: 'json',
                        categoria: 'sistema',
                        descripcion: 'Configuración general del sistema'
                    })
                });
                
                const result = await response.json();
                
                if (result.success) {
                    alert('Configuración del sistema guardada exitosamente');
                } else {
                    alert(result.error);
                }
            } catch (error) {
                alert('Error al guardar configuración');
                console.error(error);
            }
        });

        // Guardar configuración de IA
        document.getElementById('iaForm').addEventListener('submit', async (e) => {
            e.preventDefault();
            
            const formData = new FormData(e.target);
            
            try {
                const response = await fetch('api.php?action=save_ia', {
                    method: 'POST',
                    body: formData // Enviar FormData directamente
                });
                
                const result = await response.json();
                
                if (result.success) {
                    alert('Configuración de IA guardada exitosamente');
                } else {
                    alert(result.error);
                }
            } catch (error) {
                alert('Error al guardar configuración IA');
                console.error(error);
            }
        });
    </script>
</body>
</html>
```
