<?php
require_once '../../config/database.php';

$db = Database::getInstance();

// Crear tabla de categorías
$sqlCategorias = "CREATE TABLE IF NOT EXISTS biblioteca_categorias (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nombre VARCHAR(100) NOT NULL,
    tipo ENUM('documento', 'enlace') NOT NULL,
    color VARCHAR(20) DEFAULT '#3b82f6'
)";
$db->query($sqlCategorias);

// Crear tabla de items
$sqlItems = "CREATE TABLE IF NOT EXISTS biblioteca_items (
    id INT AUTO_INCREMENT PRIMARY KEY,
    titulo VARCHAR(200) NOT NULL,
    descripcion TEXT,
    tipo ENUM('documento', 'enlace') NOT NULL,
    archivo_ruta VARCHAR(255),
    url VARCHAR(500),
    categoria_id INT,
    usuario_id INT,
    fecha_creacion DATETIME DEFAULT CURRENT_TIMESTAMP,
    etiquetas VARCHAR(255),
    FOREIGN KEY (categoria_id) REFERENCES biblioteca_categorias(id),
    FOREIGN KEY (usuario_id) REFERENCES usuarios(id)
)";
$db->query($sqlItems);

// Insertar categorías por defecto si no existen
$count = $db->fetchOne("SELECT COUNT(*) as c FROM biblioteca_categorias");
if ($count['c'] == 0) {
    $db->insert('biblioteca_categorias', ['nombre' => 'Leyes y Códigos', 'tipo' => 'documento', 'color' => '#3b82f6']);
    $db->insert('biblioteca_categorias', ['nombre' => 'Jurisprudencia', 'tipo' => 'documento', 'color' => '#8b5cf6']);
    $db->insert('biblioteca_categorias', ['nombre' => 'Modelos de Escritos', 'tipo' => 'documento', 'color' => '#10b981']);
    $db->insert('biblioteca_categorias', ['nombre' => 'Doctrina', 'tipo' => 'documento', 'color' => '#f59e0b']);
    $db->insert('biblioteca_categorias', ['nombre' => 'Enlaces Judiciales', 'tipo' => 'enlace', 'color' => '#ef4444']);
    $db->insert('biblioteca_categorias', ['nombre' => 'Diarios Oficiales', 'tipo' => 'enlace', 'color' => '#6366f1']);
}

echo "Tablas de biblioteca creadas correctamente.";
