<?php
/**
 * LexiPro - API de Biblioteca Jurídica
 */

session_start();
require_once '../../includes/auth.php';
require_once '../../includes/functions.php';
require_once '../../config/database.php';

header('Content-Type: application/json; charset=utf-8');

$auth = new Auth();
$auth->requireLogin();

$db = Database::getInstance();
$userId = $_SESSION['user_id'];
$method = $_SERVER['REQUEST_METHOD'];

// GET - Listar items
if ($method === 'GET') {
    $auth->requirePermission('biblioteca', 'ver');
    
    $action = $_GET['action'] ?? 'list';
    
    if ($action === 'list') {
        $tipo = $_GET['tipo'] ?? null;
        $categoria = $_GET['categoria'] ?? null;
        $search = $_GET['search'] ?? null;
        
        $sql = "SELECT i.*, c.nombre as categoria_nombre, c.color as categoria_color, 
                u.nombre as usuario_nombre, u.apellido as usuario_apellido 
                FROM biblioteca_items i 
                LEFT JOIN biblioteca_categorias c ON i.categoria_id = c.id 
                LEFT JOIN usuarios u ON i.usuario_id = u.id 
                WHERE 1=1";
        
        $params = [];
        
        if ($tipo) {
            $sql .= " AND i.tipo = ?";
            $params[] = $tipo;
        }
        
        if ($categoria) {
            $sql .= " AND i.categoria_id = ?";
            $params[] = $categoria;
        }
        
        if ($search) {
            $sql .= " AND (i.titulo LIKE ? OR i.etiquetas LIKE ?)";
            $params[] = "%$search%";
            $params[] = "%$search%";
        }
        
        $sql .= " ORDER BY i.fecha_creacion DESC";
        
        $items = $db->fetchAll($sql, $params);
        jsonSuccess($items);
    }
    
    elseif ($action === 'categorias') {
        $categorias = $db->fetchAll("SELECT * FROM biblioteca_categorias ORDER BY nombre");
        jsonSuccess($categorias);
    }
}

// POST - Crear item
elseif ($method === 'POST') {
    $auth->requirePermission('biblioteca', 'crear');
    
    $action = $_POST['action'] ?? 'create';
    
    if ($action === 'create') {
        $titulo = $_POST['titulo'] ?? '';
        $tipo = $_POST['tipo'] ?? 'documento';
        $categoria_id = $_POST['categoria_id'] ?? null;
        $etiquetas = $_POST['etiquetas'] ?? '';
        $descripcion = $_POST['descripcion'] ?? '';
        
        if (empty($titulo) || empty($categoria_id)) {
            jsonError('Título y categoría son obligatorios');
        }
        
        $data = [
            'titulo' => $titulo,
            'tipo' => $tipo,
            'categoria_id' => $categoria_id,
            'etiquetas' => $etiquetas,
            'descripcion' => $descripcion,
            'usuario_id' => $userId
        ];
        
        if ($tipo === 'documento') {
            if (!isset($_FILES['archivo']) || $_FILES['archivo']['error'] !== UPLOAD_ERR_OK) {
                jsonError('Debe seleccionar un archivo válido');
            }
            
            $file = $_FILES['archivo'];
            $ext = strtolower(pathinfo($file['name'], PATHINFO_EXTENSION));
            $allowed = ['pdf', 'doc', 'docx', 'txt', 'rtf', 'jpg', 'png'];
            
            if (!in_array($ext, $allowed)) {
                jsonError('Tipo de archivo no permitido');
            }
            
            $filename = uniqid() . '_' . preg_replace('/[^a-z0-9\.]/', '', strtolower($file['name']));
            $path = '../../uploads/biblioteca/' . $filename;
            
            if (!move_uploaded_file($file['tmp_name'], $path)) {
                jsonError('Error al guardar el archivo');
            }
            
            $data['archivo_ruta'] = 'uploads/biblioteca/' . $filename;
            
        } else {
            $url = $_POST['url'] ?? '';
            if (empty($url)) {
                jsonError('La URL es obligatoria para enlaces');
            }
            $data['url'] = $url;
        }
        
        $id = $db->insert('biblioteca_items', $data);
        
        if ($id) {
            jsonSuccess(['id' => $id], 'Item agregado correctamente');
        } else {
            jsonError('Error al guardar en base de datos');
        }
    }
    
    elseif ($action === 'delete') {
        $id = $_POST['id'] ?? 0;
        
        // Obtener info del archivo para borrarlo
        $item = $db->fetchOne("SELECT * FROM biblioteca_items WHERE id = ?", [$id]);
        
        if ($item) {
            if ($item['tipo'] === 'documento' && !empty($item['archivo_ruta'])) {
                $filepath = '../../' . $item['archivo_ruta'];
                if (file_exists($filepath)) {
                    unlink($filepath);
                }
            }
            
            $db->delete('biblioteca_items', "id = $id");
            jsonSuccess([], 'Item eliminado');
        } else {
            jsonError('Item no encontrado');
        }
    }
}
