<?php
require_once '../../config/database.php';

try {
    $db = Database::getInstance();
    
    // Tabla carpetas
    $sql = "CREATE TABLE IF NOT EXISTS carpetas (
        id INT AUTO_INCREMENT PRIMARY KEY,
        caso_id INT NOT NULL,
        nombre VARCHAR(255) NOT NULL,
        parent_id INT NULL,
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (caso_id) REFERENCES casos(id) ON DELETE CASCADE,
        FOREIGN KEY (parent_id) REFERENCES carpetas(id) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
    $db->query($sql);
    echo "Tabla 'carpetas' creada o ya existe.<br>";

    // Tabla archivos
    $sql = "CREATE TABLE IF NOT EXISTS archivos (
        id INT AUTO_INCREMENT PRIMARY KEY,
        caso_id INT NOT NULL,
        carpeta_id INT NULL,
        nombre VARCHAR(255) NOT NULL,
        descripcion TEXT,
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (caso_id) REFERENCES casos(id) ON DELETE CASCADE,
        FOREIGN KEY (carpeta_id) REFERENCES carpetas(id) ON DELETE CASCADE
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
    $db->query($sql);
    echo "Tabla 'archivos' creada o ya existe.<br>";

    // Tabla archivo_versiones
    $sql = "CREATE TABLE IF NOT EXISTS archivo_versiones (
        id INT AUTO_INCREMENT PRIMARY KEY,
        archivo_id INT NOT NULL,
        ruta VARCHAR(255) NOT NULL,
        nombre_original VARCHAR(255) NOT NULL,
        tipo_mime VARCHAR(100),
        tamano INT,
        version INT NOT NULL DEFAULT 1,
        subido_por INT NOT NULL,
        created_at DATETIME DEFAULT CURRENT_TIMESTAMP,
        FOREIGN KEY (archivo_id) REFERENCES archivos(id) ON DELETE CASCADE,
        FOREIGN KEY (subido_por) REFERENCES usuarios(id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;";
    $db->query($sql);
    echo "Tabla 'archivo_versiones' creada o ya existe.<br>";
    
    echo "Instalación de módulo de archivos completada.";

} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
