<?php
/**
 * LexiPro - Dashboard Principal
 */

session_start();
require_once 'includes/auth.php';
require_once 'includes/functions.php';
require_once 'config/database.php';

$auth = new Auth();
$auth->requireLogin();

$db = Database::getInstance();
$currentUser = $auth->getCurrentUser();

// Obtener estadísticas
$stats = [
    'casos_activos' => $db->fetchOne("SELECT COUNT(*) as total FROM casos WHERE estado IN ('abierto', 'en_proceso')")['total'],
    'tareas_pendientes' => $db->fetchOne("SELECT COUNT(*) as total FROM tareas WHERE responsable_id = ? AND estado != 'completada'", [$currentUser['id']])['total'],
    'eventos_hoy' => $db->fetchOne("SELECT COUNT(*) as total FROM agenda WHERE usuario_id = ? AND DATE(fecha_inicio) = CURDATE()", [$currentUser['id']])['total'],
    'mensajes_nuevos' => $db->fetchOne("SELECT COUNT(*) as total FROM chat_interno WHERE receptor_id = ? AND leido = 0", [$currentUser['id']])['total']
];

// Próximos eventos
$proximosEventos = $db->fetchAll(
    "SELECT * FROM agenda WHERE usuario_id = ? AND fecha_inicio >= NOW() ORDER BY fecha_inicio ASC LIMIT 5",
    [$currentUser['id']]
);

// Tareas urgentes
$tareasUrgentes = $db->fetchAll(
    "SELECT t.*, c.nombre as caso_nombre, c.numero_caso 
     FROM tareas t
     INNER JOIN casos c ON t.caso_id = c.id
     WHERE t.responsable_id = ? AND t.estado != 'completada' 
     ORDER BY t.es_plazo_juridico DESC, t.fecha_limite ASC
     LIMIT 5",
    [$currentUser['id']]
);

// Casos recientes
$casosRecientes = $db->fetchAll(
    "SELECT c.*, cl.nombre as cliente_nombre, cl.apellido as cliente_apellido
     FROM casos c
     INNER JOIN clientes cl ON c.cliente_id = cl.id
     WHERE c.responsable_id = ? OR c.id IN (SELECT caso_id FROM casos_usuarios WHERE usuario_id = ?)
     ORDER BY c.created_at DESC
     LIMIT 5",
    [$currentUser['id'], $currentUser['id']]
);
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>LexiPro - Sistema de Gestión Jurídica</title>
    <link rel="stylesheet" href="assets/css/lexipro.css">
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: #f3f4f6;
        }
        
        .layout {
            display: flex;
            min-height: 100vh;
        }
        
        .sidebar {
            width: 260px;
            background: linear-gradient(180deg, #1e3c72 0%, #2a5298 100%);
            color: white;
            padding: 20px 0;
            position: fixed;
            height: 100vh;
            overflow-y: auto;
        }
        
        .logo {
            padding: 0 20px 20px;
            border-bottom: 1px solid rgba(255,255,255,0.1);
            margin-bottom: 20px;
        }
        
        .logo h1 {
            font-size: 24px;
            margin-bottom: 5px;
        }
        
        .logo p {
            font-size: 12px;
            opacity: 0.8;
        }
        
        .menu {
            list-style: none;
        }
        
        .menu-item {
            margin-bottom: 5px;
        }
        
        .menu-link {
            display: flex;
            align-items: center;
            gap: 12px;
            padding: 12px 20px;
            color: white;
            text-decoration: none;
            transition: all 0.3s;
            position: relative;
        }
        
        .menu-link:hover {
            background: rgba(255,255,255,0.1);
        }
        
        .menu-link.active {
            background: rgba(255,255,255,0.15);
            border-left: 3px solid white;
        }
        
        .menu-icon {
            font-size: 20px;
            width: 24px;
            text-align: center;
        }
        
        .menu-badge {
            margin-left: auto;
            background: #ef4444;
            padding: 2px 8px;
            border-radius: 12px;
            font-size: 11px;
            font-weight: bold;
        }
        
        .user-info {
            padding: 20px;
            border-top: 1px solid rgba(255,255,255,0.1);
            margin-top: 20px;
        }
        
        .user-avatar {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: white;
            color: var(--primary);
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
            margin-bottom: 10px;
        }
        
        .user-name {
            font-weight: 600;
            margin-bottom: 3px;
        }
        
        .user-role {
            font-size: 12px;
            opacity: 0.8;
        }
        
        .main-content {
            margin-left: 260px;
            flex: 1;
            padding: 30px;
        }
        
        .top-bar {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 30px;
        }
        
        .welcome h2 {
            font-size: 28px;
            margin-bottom: 5px;
        }
        
        .welcome p {
            color: #6b7280;
        }
        
        .stats-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(250px, 1fr));
            gap: 20px;
            margin-bottom: 30px;
        }
        
        .stat-card {
            background: white;
            padding: 24px;
            border-radius: 12px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
            display: flex;
            align-items: center;
            gap: 20px;
        }
        
        .stat-icon {
            width: 60px;
            height: 60px;
            border-radius: 12px;
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 28px;
        }
        
        .stat-icon.blue { background: #dbeafe; }
        .stat-icon.green { background: #d1fae5; }
        .stat-icon.orange { background: #fed7aa; }
        .stat-icon.purple { background: #e9d5ff; }
        
        .stat-info h3 {
            font-size: 32px;
            margin-bottom: 5px;
        }
        
        .stat-info p {
            color: #6b7280;
            font-size: 14px;
        }
        
        .content-grid {
            display: grid;
            grid-template-columns: 2fr 1fr;
            gap: 20px;
        }
        
        .card {
            background: white;
            border-radius: 12px;
            padding: 24px;
            box-shadow: 0 2px 8px rgba(0,0,0,0.05);
        }
        
        .card-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
        }
        
        .card-header h3 {
            font-size: 18px;
        }
        
        .card-link {
            color: var(--primary);
            text-decoration: none;
            font-size: 14px;
        }
        
        .list-item {
            padding: 15px 0;
            border-bottom: 1px solid #f3f4f6;
        }
        
        .list-item:last-child {
            border-bottom: none;
        }
        
        .list-item-header {
            display: flex;
            justify-content: space-between;
            align-items: start;
            margin-bottom: 5px;
        }
        
        .list-item-title {
            font-weight: 600;
            color: #1f2937;
        }
        
        .list-item-meta {
            font-size: 13px;
            color: #6b7280;
        }
        
        @media (max-width: 1024px) {
            .content-grid {
                grid-template-columns: 1fr;
            }
        }
        
        @media (max-width: 768px) {
            .sidebar {
                transform: translateX(-100%);
            }
            
            .main-content {
                margin-left: 0;
            }
        }
    </style>
</head>
<body>
    <div class="layout">
        <!-- Sidebar -->
        <aside class="sidebar">
            <div class="logo">
                <h1>⚖️ LexiPro</h1>
                <p>Sistema de Gestión Jurídica</p>
            </div>
            
            <ul class="menu">
                <li class="menu-item">
                    <a href="lexipro.php" class="menu-link active">
                        <span class="menu-icon">🏠</span>
                        <span>Dashboard</span>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="modules/casos/" class="menu-link">
                        <span class="menu-icon">⚖️</span>
                        <span>Casos</span>
                        <?php if ($stats['casos_activos'] > 0): ?>
                            <span class="menu-badge"><?= $stats['casos_activos'] ?></span>
                        <?php endif; ?>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="modules/clientes/" class="menu-link">
                        <span class="menu-icon">👥</span>
                        <span>Clientes</span>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="modules/agenda/" class="menu-link">
                        <span class="menu-icon">📅</span>
                        <span>Agenda</span>
                        <?php if ($stats['eventos_hoy'] > 0): ?>
                            <span class="menu-badge"><?= $stats['eventos_hoy'] ?></span>
                        <?php endif; ?>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="modules/tareas/" class="menu-link">
                        <span class="menu-icon">✓</span>
                        <span>Tareas</span>
                        <?php if ($stats['tareas_pendientes'] > 0): ?>
                            <span class="menu-badge"><?= $stats['tareas_pendientes'] ?></span>
                        <?php endif; ?>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="modules/chat/" class="menu-link">
                        <span class="menu-icon">💬</span>
                        <span>Chat</span>
                        <?php if ($stats['mensajes_nuevos'] > 0): ?>
                            <span class="menu-badge"><?= $stats['mensajes_nuevos'] ?></span>
                        <?php endif; ?>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="modules/facturacion/" class="menu-link">
                        <span class="menu-icon">💰</span>
                        <span>Facturación</span>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="modules/compras/" class="menu-link">
                        <span class="menu-icon">🛒</span>
                        <span>Compras</span>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="modules/proveedores/" class="menu-link">
                        <span class="menu-icon">🏢</span>
                        <span>Proveedores</span>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="modules/contabilidad/" class="menu-link">
                        <span class="menu-icon">📊</span>
                        <span>Contabilidad</span>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="modules/rrhh/" class="menu-link">
                        <span class="menu-icon">💼</span>
                        <span>Honorarios</span>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="modules/ia/" class="menu-link">
                        <span class="menu-icon">🤖</span>
                        <span>Asistente IA</span>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="modules/biblioteca/" class="menu-link">
                        <span class="menu-icon">📚</span>
                        <span>Biblioteca</span>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="modules/reportes/" class="menu-link">
                        <span class="menu-icon">📈</span>
                        <span>Reportes</span>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="modules/archivos/" class="menu-link">
                        <span class="menu-icon">📁</span>
                        <span>Archivos</span>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="modules/contenido-web/" class="menu-link">
                        <span class="menu-icon">🌐</span>
                        <span>Contenido Web</span>
                    </a>
                </li>
                <li class="menu-item">
                    <a href="modules/usuarios/" class="menu-link">
                        <span class="menu-icon">👤</span>
                        <span>Usuarios</span>
                    </a>
                </li>
                <?php if ($_SESSION['user_rol_nivel'] >= 100): ?>
                <li class="menu-item">
                    <a href="modules/permisos/" class="menu-link">
                        <span class="menu-icon">🛡️</span>
                        <span>Permisos</span>
                    </a>
                </li>
                <?php endif; ?>
                <li class="menu-item">
                    <a href="modules/configuracion/" class="menu-link">
                        <span class="menu-icon">⚙️</span>
                        <span>Configuración</span>
                    </a>
                </li>
            </ul>
            
            <div class="user-info">
                <div class="user-avatar">
                    <?= strtoupper(substr($currentUser['nombre'], 0, 1)) ?>
                </div>
                <div class="user-name"><?= e($currentUser['nombre'] . ' ' . $currentUser['apellido']) ?></div>
                <div class="user-role"><?= e($currentUser['rol_nombre'] ?? 'Usuario') ?></div>
                <a href="logout.php" style="color: rgba(255,255,255,0.8); text-decoration: none; font-size: 14px; margin-top: 10px; display: block;">
                    Cerrar Sesión →
                </a>
            </div>
        </aside>
        
        <!-- Main Content -->
        <main class="main-content">
            <div class="top-bar">
                <div class="welcome">
                    <h2>Bienvenido, <?= e($currentUser['nombre']) ?> 👋</h2>
                    <p><?= formatDate(date('Y-m-d')) ?></p>
                </div>
            </div>
            
            <!-- Stats -->
            <div class="stats-grid">
                <div class="stat-card">
                    <div class="stat-icon blue">⚖️</div>
                    <div class="stat-info">
                        <h3><?= $stats['casos_activos'] ?></h3>
                        <p>Casos Activos</p>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon green">✓</div>
                    <div class="stat-info">
                        <h3><?= $stats['tareas_pendientes'] ?></h3>
                        <p>Tareas Pendientes</p>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon orange">📅</div>
                    <div class="stat-info">
                        <h3><?= $stats['eventos_hoy'] ?></h3>
                        <p>Eventos Hoy</p>
                    </div>
                </div>
                
                <div class="stat-card">
                    <div class="stat-icon purple">💬</div>
                    <div class="stat-info">
                        <h3><?= $stats['mensajes_nuevos'] ?></h3>
                        <p>Mensajes Nuevos</p>
                    </div>
                </div>
            </div>
            
            <!-- Content Grid -->
            <div class="content-grid">
                <!-- Tareas Urgentes -->
                <div class="card">
                    <div class="card-header">
                        <h3>📋 Tareas Urgentes</h3>
                        <a href="modules/casos/" class="card-link">Ver todas →</a>
                    </div>
                    
                    <?php if (empty($tareasUrgentes)): ?>
                        <p style="text-align: center; color: #9ca3af; padding: 40px 0;">No tienes tareas pendientes</p>
                    <?php else: ?>
                        <?php foreach ($tareasUrgentes as $tarea): ?>
                            <div class="list-item">
                                <div class="list-item-header">
                                    <div>
                                        <?php if ($tarea['es_plazo_juridico']): ?>
                                            <span style="color: #ef4444; font-weight: bold;">⚠️ PLAZO JURÍDICO</span><br>
                                        <?php endif; ?>
                                        <span class="list-item-title"><?= e($tarea['titulo']) ?></span>
                                    </div>
                                    <span class="badge badge-<?= $tarea['prioridad'] === 'urgente' ? 'danger' : 'warning' ?>">
                                        <?= ucfirst($tarea['prioridad']) ?>
                                    </span>
                                </div>
                                <div class="list-item-meta">
                                    📁 <?= e($tarea['numero_caso']) ?> - <?= e($tarea['caso_nombre']) ?>
                                    <?php if ($tarea['fecha_limite']): ?>
                                        <br>⏰ Vence: <?= formatDate($tarea['fecha_limite']) ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
                
                <!-- Próximos Eventos -->
                <div class="card">
                    <div class="card-header">
                        <h3>📅 Próximos Eventos</h3>
                        <a href="modules/agenda/" class="card-link">Ver agenda →</a>
                    </div>
                    
                    <?php if (empty($proximosEventos)): ?>
                        <p style="text-align: center; color: #9ca3af; padding: 40px 0;">No hay eventos próximos</p>
                    <?php else: ?>
                        <?php foreach ($proximosEventos as $evento): ?>
                            <div class="list-item">
                                <div class="list-item-title"><?= e($evento['titulo']) ?></div>
                                <div class="list-item-meta">
                                    📅 <?= formatDateTime($evento['fecha_inicio']) ?>
                                    <?php if ($evento['ubicacion']): ?>
                                        <br>📍 <?= e($evento['ubicacion']) ?>
                                    <?php endif; ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    <?php endif; ?>
                </div>
            </div>
            
            <!-- Casos Recientes -->
            <div class="card" style="margin-top: 20px;">
                <div class="card-header">
                    <h3>⚖️ Casos Recientes</h3>
                    <a href="modules/casos/" class="card-link">Ver todos →</a>
                </div>
                
                <?php if (empty($casosRecientes)): ?>
                    <p style="text-align: center; color: #9ca3af; padding: 40px 0;">No hay casos recientes</p>
                <?php else: ?>
                    <div style="display: grid; grid-template-columns: repeat(auto-fill, minmax(300px, 1fr)); gap: 15px;">
                        <?php foreach ($casosRecientes as $caso): ?>
                            <div style="padding: 15px; border: 2px solid #e5e7eb; border-radius: 8px;">
                                <div style="display: flex; justify-content: space-between; align-items: start; margin-bottom: 8px;">
                                    <span style="font-weight: 600; color: #1f2937;"><?= e($caso['numero_caso']) ?></span>
                                    <span class="badge badge-<?= $caso['estado'] === 'cerrado' ? 'success' : 'info' ?>">
                                        <?= ucfirst(str_replace('_', ' ', $caso['estado'])) ?>
                                    </span>
                                </div>
                                <div style="font-size: 15px; margin-bottom: 8px;"><?= e($caso['nombre']) ?></div>
                                <div style="font-size: 13px; color: #6b7280;">
                                    👤 <?= e($caso['cliente_nombre'] . ' ' . ($caso['cliente_apellido'] ?? '')) ?>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                <?php endif; ?>
            </div>
        </main>
    </div>
</body>
</html>
