-- ============================================
-- LEXIPRO - Permisos Iniciales por Rol
-- Script para configurar permisos de todos los módulos
-- ============================================

-- Limpiar permisos existentes (opcional, comentar si no deseas limpiar)
-- DELETE FROM permisos;

-- ============================================
-- PERMISOS PARA ADMINISTRADOR GENERAL (ID: 1)
-- Acceso total a todos los módulos
-- ============================================
INSERT INTO `permisos` (`rol_id`, `modulo`, `ver`, `crear`, `editar`, `eliminar`) VALUES
(1, 'usuarios', 1, 1, 1, 1),
(1, 'casos', 1, 1, 1, 1),
(1, 'clientes', 1, 1, 1, 1),
(1, 'agenda', 1, 1, 1, 1),
(1, 'tareas', 1, 1, 1, 1),
(1, 'chat', 1, 1, 1, 1),
(1, 'facturacion', 1, 1, 1, 1),
(1, 'compras', 1, 1, 1, 1),
(1, 'proveedores', 1, 1, 1, 1),
(1, 'contabilidad', 1, 1, 1, 1),
(1, 'honorarios', 1, 1, 1, 1),
(1, 'ia', 1, 1, 1, 1),
(1, 'biblioteca', 1, 1, 1, 1),
(1, 'reportes', 1, 1, 1, 1),
(1, 'archivos', 1, 1, 1, 1),
(1, 'configuracion', 1, 1, 1, 1),
(1, 'contenido_web', 1, 1, 1, 1),
(1, 'notificaciones', 1, 1, 1, 1)
ON DUPLICATE KEY UPDATE ver=1, crear=1, editar=1, eliminar=1;

-- ============================================
-- PERMISOS PARA ABOGADO SENIOR (ID: 2)
-- Acceso completo excepto usuarios y configuración
-- ============================================
INSERT INTO `permisos` (`rol_id`, `modulo`, `ver`, `crear`, `editar`, `eliminar`) VALUES
(2, 'usuarios', 1, 0, 0, 0),
(2, 'casos', 1, 1, 1, 1),
(2, 'clientes', 1, 1, 1, 1),
(2, 'agenda', 1, 1, 1, 1),
(2, 'tareas', 1, 1, 1, 1),
(2, 'chat', 1, 1, 1, 1),
(2, 'facturacion', 1, 1, 1, 1),
(2, 'compras', 1, 1, 1, 0),
(2, 'proveedores', 1, 1, 1, 0),
(2, 'contabilidad', 1, 1, 1, 0),
(2, 'honorarios', 1, 0, 0, 0),
(2, 'ia', 1, 1, 1, 0),
(2, 'biblioteca', 1, 1, 1, 1),
(2, 'reportes', 1, 1, 1, 0),
(2, 'archivos', 1, 1, 1, 1),
(2, 'configuracion', 1, 0, 0, 0),
(2, 'contenido_web', 1, 0, 0, 0),
(2, 'notificaciones', 1, 1, 1, 1)
ON DUPLICATE KEY UPDATE ver=VALUES(ver), crear=VALUES(crear), editar=VALUES(editar), eliminar=VALUES(eliminar);

-- ============================================
-- PERMISOS PARA ABOGADO JUNIOR (ID: 3)
-- Acceso limitado, principalmente ver y crear
-- ============================================
INSERT INTO `permisos` (`rol_id`, `modulo`, `ver`, `crear`, `editar`, `eliminar`) VALUES
(3, 'usuarios', 1, 0, 0, 0),
(3, 'casos', 1, 1, 1, 0),
(3, 'clientes', 1, 1, 1, 0),
(3, 'agenda', 1, 1, 1, 0),
(3, 'tareas', 1, 1, 1, 0),
(3, 'chat', 1, 1, 1, 0),
(3, 'facturacion', 1, 1, 0, 0),
(3, 'compras', 1, 0, 0, 0),
(3, 'proveedores', 1, 0, 0, 0),
(3, 'contabilidad', 1, 0, 0, 0),
(3, 'honorarios', 1, 0, 0, 0),
(3, 'ia', 1, 1, 0, 0),
(3, 'biblioteca', 1, 1, 1, 0),
(3, 'reportes', 1, 0, 0, 0),
(3, 'archivos', 1, 1, 1, 0),
(3, 'configuracion', 0, 0, 0, 0),
(3, 'contenido_web', 0, 0, 0, 0),
(3, 'notificaciones', 1, 1, 1, 0)
ON DUPLICATE KEY UPDATE ver=VALUES(ver), crear=VALUES(crear), editar=VALUES(editar), eliminar=VALUES(eliminar);

-- ============================================
-- PERMISOS PARA NOTARIO (ID: 4)
-- Enfocado en casos, clientes y biblioteca
-- ============================================
INSERT INTO `permisos` (`rol_id`, `modulo`, `ver`, `crear`, `editar`, `eliminar`) VALUES
(4, 'usuarios', 1, 0, 0, 0),
(4, 'casos', 1, 1, 1, 1),
(4, 'clientes', 1, 1, 1, 0),
(4, 'agenda', 1, 1, 1, 0),
(4, 'tareas', 1, 1, 1, 0),
(4, 'chat', 1, 1, 1, 0),
(4, 'facturacion', 1, 1, 1, 0),
(4, 'compras', 1, 0, 0, 0),
(4, 'proveedores', 1, 0, 0, 0),
(4, 'contabilidad', 1, 0, 0, 0),
(4, 'honorarios', 1, 0, 0, 0),
(4, 'ia', 1, 1, 0, 0),
(4, 'biblioteca', 1, 1, 1, 1),
(4, 'reportes', 1, 0, 0, 0),
(4, 'archivos', 1, 1, 1, 1),
(4, 'configuracion', 0, 0, 0, 0),
(4, 'contenido_web', 0, 0, 0, 0),
(4, 'notificaciones', 1, 1, 1, 0)
ON DUPLICATE KEY UPDATE ver=VALUES(ver), crear=VALUES(crear), editar=VALUES(editar), eliminar=VALUES(eliminar);

-- ============================================
-- PERMISOS PARA ACTUARIO (ID: 5)
-- Enfocado en casos, agenda y tareas
-- ============================================
INSERT INTO `permisos` (`rol_id`, `modulo`, `ver`, `crear`, `editar`, `eliminar`) VALUES
(5, 'usuarios', 1, 0, 0, 0),
(5, 'casos', 1, 1, 1, 0),
(5, 'clientes', 1, 1, 1, 0),
(5, 'agenda', 1, 1, 1, 0),
(5, 'tareas', 1, 1, 1, 0),
(5, 'chat', 1, 1, 1, 0),
(5, 'facturacion', 1, 0, 0, 0),
(5, 'compras', 1, 0, 0, 0),
(5, 'proveedores', 1, 0, 0, 0),
(5, 'contabilidad', 1, 0, 0, 0),
(5, 'honorarios', 1, 0, 0, 0),
(5, 'ia', 1, 1, 0, 0),
(5, 'biblioteca', 1, 1, 0, 0),
(5, 'reportes', 1, 0, 0, 0),
(5, 'archivos', 1, 1, 1, 0),
(5, 'configuracion', 0, 0, 0, 0),
(5, 'contenido_web', 0, 0, 0, 0),
(5, 'notificaciones', 1, 1, 1, 0)
ON DUPLICATE KEY UPDATE ver=VALUES(ver), crear=VALUES(crear), editar=VALUES(editar), eliminar=VALUES(eliminar);

-- ============================================
-- PERMISOS PARA SECRETARIO (ID: 6)
-- Enfocado en agenda, clientes, chat y archivos
-- ============================================
INSERT INTO `permisos` (`rol_id`, `modulo`, `ver`, `crear`, `editar`, `eliminar`) VALUES
(6, 'usuarios', 1, 0, 0, 0),
(6, 'casos', 1, 0, 0, 0),
(6, 'clientes', 1, 1, 1, 0),
(6, 'agenda', 1, 1, 1, 1),
(6, 'tareas', 1, 1, 1, 0),
(6, 'chat', 1, 1, 1, 1),
(6, 'facturacion', 1, 1, 0, 0),
(6, 'compras', 1, 1, 0, 0),
(6, 'proveedores', 1, 1, 1, 0),
(6, 'contabilidad', 1, 0, 0, 0),
(6, 'honorarios', 1, 0, 0, 0),
(6, 'ia', 1, 1, 0, 0),
(6, 'biblioteca', 1, 1, 0, 0),
(6, 'reportes', 1, 0, 0, 0),
(6, 'archivos', 1, 1, 1, 0),
(6, 'configuracion', 0, 0, 0, 0),
(6, 'contenido_web', 1, 1, 1, 0),
(6, 'notificaciones', 1, 1, 1, 0)
ON DUPLICATE KEY UPDATE ver=VALUES(ver), crear=VALUES(crear), editar=VALUES(editar), eliminar=VALUES(eliminar);

-- ============================================
-- PERMISOS PARA OFICIAL (ID: 7)
-- Acceso básico de lectura y tareas asignadas
-- ============================================
INSERT INTO `permisos` (`rol_id`, `modulo`, `ver`, `crear`, `editar`, `eliminar`) VALUES
(7, 'usuarios', 1, 0, 0, 0),
(7, 'casos', 1, 0, 0, 0),
(7, 'clientes', 1, 0, 0, 0),
(7, 'agenda', 1, 1, 1, 0),
(7, 'tareas', 1, 1, 1, 0),
(7, 'chat', 1, 1, 1, 0),
(7, 'facturacion', 1, 0, 0, 0),
(7, 'compras', 1, 0, 0, 0),
(7, 'proveedores', 1, 0, 0, 0),
(7, 'contabilidad', 1, 0, 0, 0),
(7, 'honorarios', 1, 0, 0, 0),
(7, 'ia', 1, 1, 0, 0),
(7, 'biblioteca', 1, 0, 0, 0),
(7, 'reportes', 1, 0, 0, 0),
(7, 'archivos', 1, 1, 0, 0),
(7, 'configuracion', 0, 0, 0, 0),
(7, 'contenido_web', 0, 0, 0, 0),
(7, 'notificaciones', 1, 1, 1, 0)
ON DUPLICATE KEY UPDATE ver=VALUES(ver), crear=VALUES(crear), editar=VALUES(editar), eliminar=VALUES(eliminar);

-- ============================================
-- PERMISOS PARA GESTOR (ID: 8)
-- Similar a Oficial, enfocado en gestión de casos
-- ============================================
INSERT INTO `permisos` (`rol_id`, `modulo`, `ver`, `crear`, `editar`, `eliminar`) VALUES
(8, 'usuarios', 1, 0, 0, 0),
(8, 'casos', 1, 1, 1, 0),
(8, 'clientes', 1, 1, 1, 0),
(8, 'agenda', 1, 1, 1, 0),
(8, 'tareas', 1, 1, 1, 0),
(8, 'chat', 1, 1, 1, 0),
(8, 'facturacion', 1, 0, 0, 0),
(8, 'compras', 1, 0, 0, 0),
(8, 'proveedores', 1, 0, 0, 0),
(8, 'contabilidad', 1, 0, 0, 0),
(8, 'honorarios', 1, 0, 0, 0),
(8, 'ia', 1, 1, 0, 0),
(8, 'biblioteca', 1, 1, 0, 0),
(8, 'reportes', 1, 0, 0, 0),
(8, 'archivos', 1, 1, 1, 0),
(8, 'configuracion', 0, 0, 0, 0),
(8, 'contenido_web', 0, 0, 0, 0),
(8, 'notificaciones', 1, 1, 1, 0)
ON DUPLICATE KEY UPDATE ver=VALUES(ver), crear=VALUES(crear), editar=VALUES(editar), eliminar=VALUES(eliminar);

-- ============================================
-- FIN DEL SCRIPT DE PERMISOS INICIALES
-- ============================================
