<?php
/**
 * LexiPro - Sistema de Gestión Jurídica
 * Instalador Web
 */

// Evitar acceso si ya está instalado
if (file_exists('../config/config.php')) {
    $config = include '../config/config.php';
    if (isset($config['installed']) && $config['installed'] === true) {
        die('El sistema ya está instalado. Si deseas reinstalar, elimina el archivo config/config.php');
    }
}

session_start();

// Procesar formulario
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $step = $_POST['step'] ?? 1;
    
    if ($step == 1) {
        // Guardar datos de base de datos en sesión
        $_SESSION['db_host'] = $_POST['db_host'];
        $_SESSION['db_name'] = $_POST['db_name'];
        $_SESSION['db_user'] = $_POST['db_user'];
        $_SESSION['db_pass'] = $_POST['db_pass'];
        
        // Probar conexión
        try {
            $pdo = new PDO(
                "mysql:host={$_POST['db_host']};charset=utf8mb4",
                $_POST['db_user'],
                $_POST['db_pass'],
                [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
            );
            
            // Crear base de datos si no existe
            $pdo->exec("CREATE DATABASE IF NOT EXISTS `{$_POST['db_name']}` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
            $pdo->exec("USE `{$_POST['db_name']}`");
            
            $_SESSION['step'] = 2;
            header('Location: index.php');
            exit;
        } catch (PDOException $e) {
            $error = "Error de conexión: " . $e->getMessage();
        }
    }
    
    if ($step == 2) {
        // Ejecutar SQL
        try {
            $pdo = new PDO(
                "mysql:host={$_SESSION['db_host']};dbname={$_SESSION['db_name']};charset=utf8mb4",
                $_SESSION['db_user'],
                $_SESSION['db_pass'],
                [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
            );
            
            // Leer y ejecutar SQL
            $sql = file_get_contents('database.sql');
            $pdo->exec($sql);
            
            $_SESSION['step'] = 3;
            header('Location: index.php');
            exit;
        } catch (PDOException $e) {
            $error = "Error al crear tablas: " . $e->getMessage();
        }
    }
    
    if ($step == 3) {
        // Crear usuario administrador
        try {
            $pdo = new PDO(
                "mysql:host={$_SESSION['db_host']};dbname={$_SESSION['db_name']};charset=utf8mb4",
                $_SESSION['db_user'],
                $_SESSION['db_pass'],
                [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
            );
            
            // Insertar usuario admin
            $password = password_hash($_POST['admin_password'], PASSWORD_DEFAULT);
            $stmt = $pdo->prepare("INSERT INTO usuarios (nombre, apellido, usuario, password, email, rol_id, activo) VALUES (?, ?, ?, ?, ?, 1, 1)");
            $stmt->execute([
                $_POST['admin_nombre'],
                $_POST['admin_apellido'],
                $_POST['admin_usuario'],
                $password,
                $_POST['admin_email']
            ]);
            
            $_SESSION['step'] = 4;
            header('Location: index.php');
            exit;
        } catch (PDOException $e) {
            $error = "Error al crear usuario: " . $e->getMessage();
        }
    }
    
    if ($step == 4) {
        // Configurar empresa
        try {
            $pdo = new PDO(
                "mysql:host={$_SESSION['db_host']};dbname={$_SESSION['db_name']};charset=utf8mb4",
                $_SESSION['db_user'],
                $_SESSION['db_pass'],
                [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
            );
            
            // Insertar configuración
            $stmt = $pdo->prepare("INSERT INTO configuracion (nombre_empresa, razon_social, ruc, representante_legal, direccion, telefono, email) VALUES (?, ?, ?, ?, ?, ?, ?)");
            $stmt->execute([
                $_POST['nombre_empresa'],
                $_POST['razon_social'],
                $_POST['ruc'],
                $_POST['representante_legal'],
                $_POST['direccion'],
                $_POST['telefono'],
                $_POST['email_empresa']
            ]);
            
            // Crear archivo de configuración
            $configContent = "<?php\nreturn [\n";
            $configContent .= "    'db_host' => '{$_SESSION['db_host']}',\n";
            $configContent .= "    'db_name' => '{$_SESSION['db_name']}',\n";
            $configContent .= "    'db_user' => '{$_SESSION['db_user']}',\n";
            $configContent .= "    'db_pass' => '{$_SESSION['db_pass']}',\n";
            $configContent .= "    'installed' => true,\n";
            $configContent .= "    'timezone' => 'America/Asuncion',\n";
            $configContent .= "    'app_name' => 'LexiPro',\n";
            $configContent .= "    'app_version' => '1.0.0'\n";
            $configContent .= "];\n";
            
            if (!is_dir('../config')) {
                mkdir('../config', 0755, true);
            }
            file_put_contents('../config/config.php', $configContent);
            
            // Crear directorios necesarios
            $dirs = [
                '../uploads/usuarios',
                '../uploads/casos',
                '../uploads/tareas',
                '../uploads/archivos',
                '../uploads/biblioteca',
                '../uploads/logos'
            ];
            
            foreach ($dirs as $dir) {
                if (!is_dir($dir)) {
                    mkdir($dir, 0755, true);
                }
            }
            
            $_SESSION['step'] = 5;
            header('Location: index.php');
            exit;
        } catch (Exception $e) {
            $error = "Error al configurar sistema: " . $e->getMessage();
        }
    }
}

$currentStep = $_SESSION['step'] ?? 1;
?>
<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Instalador LexiPro</title>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 20px;
        }
        
        .installer {
            background: white;
            border-radius: 20px;
            box-shadow: 0 20px 60px rgba(0,0,0,0.3);
            max-width: 600px;
            width: 100%;
            overflow: hidden;
        }
        
        .header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            padding: 30px;
            text-align: center;
        }
        
        .header h1 {
            font-size: 32px;
            margin-bottom: 10px;
        }
        
        .header p {
            opacity: 0.9;
            font-size: 14px;
        }
        
        .progress {
            display: flex;
            padding: 20px 30px;
            background: #f8f9fa;
            border-bottom: 1px solid #e9ecef;
        }
        
        .progress-step {
            flex: 1;
            text-align: center;
            position: relative;
        }
        
        .progress-step::before {
            content: '';
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background: #dee2e6;
            display: block;
            margin: 0 auto 8px;
            line-height: 30px;
            color: white;
            font-weight: bold;
        }
        
        .progress-step.active::before {
            background: #667eea;
        }
        
        .progress-step.completed::before {
            background: #28a745;
            content: '✓';
        }
        
        .progress-step span {
            font-size: 12px;
            color: #6c757d;
        }
        
        .progress-step.active span {
            color: #667eea;
            font-weight: bold;
        }
        
        .content {
            padding: 40px;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        label {
            display: block;
            margin-bottom: 8px;
            font-weight: 600;
            color: #333;
        }
        
        input[type="text"],
        input[type="email"],
        input[type="password"] {
            width: 100%;
            padding: 12px 15px;
            border: 2px solid #e9ecef;
            border-radius: 8px;
            font-size: 14px;
            transition: all 0.3s;
        }
        
        input:focus {
            outline: none;
            border-color: #667eea;
        }
        
        .btn {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border: none;
            padding: 14px 30px;
            border-radius: 8px;
            font-size: 16px;
            font-weight: 600;
            cursor: pointer;
            width: 100%;
            transition: transform 0.2s;
        }
        
        .btn:hover {
            transform: translateY(-2px);
        }
        
        .error {
            background: #f8d7da;
            color: #721c24;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
            border-left: 4px solid #f5c6cb;
        }
        
        .success {
            background: #d4edda;
            color: #155724;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
            border-left: 4px solid #c3e6cb;
        }
        
        .info {
            background: #d1ecf1;
            color: #0c5460;
            padding: 12px;
            border-radius: 8px;
            margin-bottom: 20px;
            border-left: 4px solid #bee5eb;
            font-size: 14px;
        }
        
        .requirements {
            list-style: none;
        }
        
        .requirements li {
            padding: 8px 0;
            border-bottom: 1px solid #e9ecef;
        }
        
        .requirements li:last-child {
            border-bottom: none;
        }
        
        .check {
            color: #28a745;
            margin-right: 10px;
        }
        
        .cross {
            color: #dc3545;
            margin-right: 10px;
        }
        
        .complete-message {
            text-align: center;
            padding: 40px 20px;
        }
        
        .complete-message h2 {
            color: #28a745;
            margin-bottom: 20px;
        }
        
        .complete-message p {
            color: #6c757d;
            margin-bottom: 30px;
        }
    </style>
</head>
<body>
    <div class="installer">
        <div class="header">
            <h1>⚖️ LexiPro</h1>
            <p>Sistema de Gestión para Estudios Jurídicos</p>
        </div>
        
        <div class="progress">
            <div class="progress-step <?= $currentStep >= 1 ? 'active' : '' ?> <?= $currentStep > 1 ? 'completed' : '' ?>">
                <span>Requisitos</span>
            </div>
            <div class="progress-step <?= $currentStep >= 2 ? 'active' : '' ?> <?= $currentStep > 2 ? 'completed' : '' ?>">
                <span>Base de Datos</span>
            </div>
            <div class="progress-step <?= $currentStep >= 3 ? 'active' : '' ?> <?= $currentStep > 3 ? 'completed' : '' ?>">
                <span>Administrador</span>
            </div>
            <div class="progress-step <?= $currentStep >= 4 ? 'active' : '' ?> <?= $currentStep > 4 ? 'completed' : '' ?>">
                <span>Empresa</span>
            </div>
            <div class="progress-step <?= $currentStep >= 5 ? 'active' : '' ?>">
                <span>Finalizar</span>
            </div>
        </div>
        
        <div class="content">
            <?php if (isset($error)): ?>
                <div class="error"><?= htmlspecialchars($error) ?></div>
            <?php endif; ?>
            
            <?php if ($currentStep == 1): ?>
                <h2>Verificación de Requisitos</h2>
                <div class="info">
                    Verificando que el servidor cumple con los requisitos mínimos...
                </div>
                
                <ul class="requirements">
                    <li>
                        <?php if (version_compare(PHP_VERSION, '7.4.0') >= 0): ?>
                            <span class="check">✓</span> PHP <?= PHP_VERSION ?> (Requerido: 7.4+)
                        <?php else: ?>
                            <span class="cross">✗</span> PHP <?= PHP_VERSION ?> (Requerido: 7.4+)
                        <?php endif; ?>
                    </li>
                    <li>
                        <?php if (extension_loaded('pdo')): ?>
                            <span class="check">✓</span> PDO Extension
                        <?php else: ?>
                            <span class="cross">✗</span> PDO Extension (Requerida)
                        <?php endif; ?>
                    </li>
                    <li>
                        <?php if (extension_loaded('pdo_mysql')): ?>
                            <span class="check">✓</span> PDO MySQL Extension
                        <?php else: ?>
                            <span class="cross">✗</span> PDO MySQL Extension (Requerida)
                        <?php endif; ?>
                    </li>
                    <li>
                        <?php if (extension_loaded('mbstring')): ?>
                            <span class="check">✓</span> MBString Extension
                        <?php else: ?>
                            <span class="cross">✗</span> MBString Extension (Requerida)
                        <?php endif; ?>
                    </li>
                    <li>
                        <?php if (is_writable('..')): ?>
                            <span class="check">✓</span> Permisos de escritura
                        <?php else: ?>
                            <span class="cross">✗</span> Permisos de escritura (Requeridos)
                        <?php endif; ?>
                    </li>
                </ul>
                
                <form method="POST" style="margin-top: 30px;">
                    <input type="hidden" name="step" value="1">
                    
                    <h3 style="margin-bottom: 20px;">Configuración de Base de Datos</h3>
                    
                    <div class="form-group">
                        <label>Host de Base de Datos</label>
                        <input type="text" name="db_host" value="localhost" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Nombre de Base de Datos</label>
                        <input type="text" name="db_name" value="lexipro" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Usuario de Base de Datos</label>
                        <input type="text" name="db_user" value="root" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Contraseña de Base de Datos</label>
                        <input type="password" name="db_pass">
                    </div>
                    
                    <button type="submit" class="btn">Continuar →</button>
                </form>
            
            <?php elseif ($currentStep == 2): ?>
                <h2>Creando Tablas</h2>
                <div class="success">
                    ✓ Conexión a base de datos exitosa
                </div>
                <div class="info">
                    Se crearán todas las tablas necesarias para el sistema...
                </div>
                
                <form method="POST" style="margin-top: 30px;">
                    <input type="hidden" name="step" value="2">
                    <button type="submit" class="btn">Crear Tablas →</button>
                </form>
            
            <?php elseif ($currentStep == 3): ?>
                <h2>Usuario Administrador</h2>
                <div class="success">
                    ✓ Tablas creadas exitosamente
                </div>
                <div class="info">
                    Crea el usuario administrador del sistema
                </div>
                
                <form method="POST" style="margin-top: 30px;">
                    <input type="hidden" name="step" value="3">
                    
                    <div class="form-group">
                        <label>Nombre</label>
                        <input type="text" name="admin_nombre" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Apellido</label>
                        <input type="text" name="admin_apellido" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Usuario</label>
                        <input type="text" name="admin_usuario" value="admin" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Email</label>
                        <input type="email" name="admin_email" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Contraseña</label>
                        <input type="password" name="admin_password" required>
                    </div>
                    
                    <button type="submit" class="btn">Crear Administrador →</button>
                </form>
            
            <?php elseif ($currentStep == 4): ?>
                <h2>Datos de la Empresa</h2>
                <div class="success">
                    ✓ Usuario administrador creado
                </div>
                <div class="info">
                    Configura los datos de tu estudio jurídico
                </div>
                
                <form method="POST" style="margin-top: 30px;">
                    <input type="hidden" name="step" value="4">
                    
                    <div class="form-group">
                        <label>Nombre de la Empresa</label>
                        <input type="text" name="nombre_empresa" required>
                    </div>
                    
                    <div class="form-group">
                        <label>Razón Social</label>
                        <input type="text" name="razon_social">
                    </div>
                    
                    <div class="form-group">
                        <label>RUC</label>
                        <input type="text" name="ruc">
                    </div>
                    
                    <div class="form-group">
                        <label>Representante Legal</label>
                        <input type="text" name="representante_legal">
                    </div>
                    
                    <div class="form-group">
                        <label>Dirección</label>
                        <input type="text" name="direccion">
                    </div>
                    
                    <div class="form-group">
                        <label>Teléfono</label>
                        <input type="text" name="telefono">
                    </div>
                    
                    <div class="form-group">
                        <label>Email</label>
                        <input type="email" name="email_empresa">
                    </div>
                    
                    <button type="submit" class="btn">Finalizar Instalación →</button>
                </form>
            
            <?php elseif ($currentStep == 5): ?>
                <div class="complete-message">
                    <h2>🎉 ¡Instalación Completada!</h2>
                    <p>LexiPro ha sido instalado exitosamente en tu servidor.</p>
                    
                    <div class="success" style="text-align: left;">
                        <strong>Próximos pasos:</strong><br>
                        1. Elimina o renombra la carpeta /install por seguridad<br>
                        2. Accede al sistema con tus credenciales de administrador<br>
                        3. Configura el logo de tu empresa en Configuración<br>
                        4. Crea los usuarios del estudio<br>
                        5. Comienza a gestionar tus casos
                    </div>
                    
                    <a href="../login.php" class="btn" style="display: inline-block; text-decoration: none; margin-top: 20px;">
                        Ir al Login →
                    </a>
                </div>
            <?php endif; ?>
        </div>
    </div>
</body>
</html>
