<?php
/**
 * Script para agregar requirePermission() a módulos restantes
 * Ejecutar: php add_permissions_batch.php
 */

$modulesPath = __DIR__ . '/../modules';

// Módulos que necesitan permisos (excluir los ya completados)
$modules = [
    'chat',
    'compras',
    'proveedores',
    'contabilidad',
    'rrhh',
    'ia',
    'biblioteca',
    'reportes',
    'archivos',
    'configuracion'
];

$methodPermissionMap = [
    'GET' => 'ver',
    'POST' => 'crear',
    'PUT' => 'editar',
    'DELETE' => 'eliminar'
];

echo "Agregando permisos a módulos restantes...\n\n";

foreach ($modules as $module) {
    $apiFile = "$modulesPath/$module/api.php";
    
    if (!file_exists($apiFile)) {
        echo "⚠️  $module/api.php no existe, saltando...\n";
        continue;
    }
    
    $content = file_get_contents($apiFile);
    
    // Verificar si ya tiene permisos
    if (strpos($content, 'requirePermission') !== false) {
        echo "✓ $module/api.php ya tiene permisos\n";
        continue;
    }
    
    echo "Procesando $module/api.php...\n";
    $modified = false;
    
    foreach ($methodPermissionMap as $method => $permission) {
        // Buscar patrón: if ($method === 'GET') {
        $patterns = [
            "/if\s*\(\s*\\\$method\s*===\s*['\"]$method['\"]\s*\)\s*\{/",
            "/elseif\s*\(\s*\\\$method\s*===\s*['\"]$method['\"]\s*\)\s*\{/"
        ];
        
        foreach ($patterns as $pattern) {
            if (preg_match($pattern, $content, $matches, PREG_OFFSET_CAPTURE)) {
                $matchPos = $matches[0][1];
                $matchLen = strlen($matches[0][0]);
                
                // Insertar requirePermission después de la llave
                $insertion = "\n        \$auth->requirePermission('$module', '$permission');\n        ";
                
                $content = substr_replace($content, $matches[0][0] . $insertion, $matchPos, $matchLen);
                
                $modified = true;
                echo "  + Agregado permiso '$permission' para método $method\n";
                break; // Solo procesar la primera coincidencia
            }
        }
    }
    
    if ($modified) {
        file_put_contents($apiFile, $content);
        echo "✓ $module/api.php actualizado\n\n";
    } else {
        echo "⚠️  $module/api.php no se pudo actualizar (patrón no encontrado)\n\n";
    }
}

echo "\n✅ Proceso completado!\n";
echo "Módulos procesados: " . count($modules) . "\n";
