<?php
/**
 * Script para agregar requirePermission() a todos los módulos
 * Ejecutar desde línea de comandos: php add_permissions.php
 */

$modulesPath = __DIR__ . '/../modules';

// Módulos que necesitan permisos
$modules = [
    'agenda' => ['ver', 'crear', 'editar', 'eliminar'],
    'tareas' => ['ver', 'crear', 'editar', 'eliminar'],
    'chat' => ['ver', 'crear', 'editar', 'eliminar'],
    'facturacion' => ['ver', 'crear', 'editar', 'eliminar'],
    'compras' => ['ver', 'crear', 'editar', 'eliminar'],
    'proveedores' => ['ver', 'crear', 'editar', 'eliminar'],
    'contabilidad' => ['ver', 'crear', 'editar', 'eliminar'],
    'rrhh' => ['ver', 'crear', 'editar', 'eliminar'],
    'ia' => ['ver', 'crear', 'editar', 'eliminar'],
    'biblioteca' => ['ver', 'crear', 'editar', 'eliminar'],
    'reportes' => ['ver', 'crear', 'editar', 'eliminar'],
    'archivos' => ['ver', 'crear', 'editar', 'eliminar'],
    'configuracion' => ['ver', 'crear', 'editar', 'eliminar'],
    'notificaciones' => ['ver', 'crear', 'editar', 'eliminar']
];

$methodPermissionMap = [
    'GET' => 'ver',
    'POST' => 'crear',
    'PUT' => 'editar',
    'DELETE' => 'eliminar'
];

echo "Agregando permisos a módulos...\n\n";

foreach ($modules as $module => $permissions) {
    $apiFile = "$modulesPath/$module/api.php";
    
    if (!file_exists($apiFile)) {
        echo "⚠️  $module/api.php no existe, saltando...\n";
        continue;
    }
    
    $content = file_get_contents($apiFile);
    
    // Verificar si ya tiene permisos
    if (strpos($content, 'requirePermission') !== false) {
        echo "✓ $module/api.php ya tiene permisos\n";
        continue;
    }
    
    // Agregar permisos para cada método HTTP
    $modified = false;
    
    foreach ($methodPermissionMap as $method => $permission) {
        // Buscar el patrón: if ($method === 'GET') {
        $pattern = "/if\s*\(\s*\\\$method\s*===\s*['\"]$method['\"]\s*\)\s*\{/";
        
        if (preg_match($pattern, $content)) {
            // Agregar requirePermission después de la llave de apertura
            $replacement = "if (\$method === '$method') {\n        \$auth->requirePermission('$module', '$permission');\n        ";
            $content = preg_replace($pattern, $replacement, $content, 1);
            $modified = true;
            echo "  + Agregado permiso '$permission' para método $method\n";
        }
    }
    
    if ($modified) {
        file_put_contents($apiFile, $content);
        echo "✓ $module/api.php actualizado\n\n";
    } else {
        echo "⚠️  $module/api.php no se pudo actualizar (patrón no encontrado)\n\n";
    }
}

echo "\n✅ Proceso completado!\n";
