            ⚖️ LexiPro
        </a>
        
        <?php if (isset($breadcrumbs) && !empty($breadcrumbs)): ?>
            <nav class="breadcrumb">
                <a href="/lexipro/lexipro.php">Inicio</a>
                <?php foreach ($breadcrumbs as $crumb): ?>
                    <span class="breadcrumb-separator">›</span>
                    <?php if (isset($crumb['url'])): ?>
                        <a href="<?= $crumb['url'] ?>"><?= $crumb['label'] ?></a>
                    <?php else: ?>
                        <span><?= $crumb['label'] ?></span>
                    <?php endif; ?>
                <?php endforeach; ?>
            </nav>
        <?php endif; ?>
    </div>
    
    <div class="header-right">
        <div class="quick-actions">
            <button class="quick-btn" onclick="window.location.href='/lexipro/modules/casos/'">
                ⚖️ Nuevo Caso
            </button>
            <button class="quick-btn" onclick="window.location.href='/lexipro/modules/agenda/'">
                📅 Agenda
            </button>
        </div>
        
        <div class="search-box">
            <span class="search-icon">🔍</span>
            <input type="text" class="search-input" placeholder="Buscar casos, clientes, tareas..." id="globalSearch">
        </div>
        
        <button class="notifications-btn" onclick="toggleNotifications()">
            🔔
            <span class="notification-badge" id="notificationCount" style="display: none;">0</span>
        </button>
        
        <div class="user-menu">
            <button class="user-btn" onclick="toggleUserMenu()">
                <div class="user-avatar-small">
                    <?= strtoupper(substr($currentUser['nombre'], 0, 1) . substr($currentUser['apellido'], 0, 1)) ?>
                </div>
                <span><?= e($currentUser['nombre']) ?></span>
                <span>▼</span>
            </button>
            
            <div class="user-dropdown" id="userDropdown">
                <a href="/lexipro/modules/usuarios/?id=<?= $currentUser['id'] ?>" class="user-dropdown-item">
                    👤 Mi Perfil
                </a>
                <a href="/lexipro/modules/agenda/" class="user-dropdown-item">
                    📅 Mi Agenda
                </a>
                <a href="/lexipro/modules/chat/" class="user-dropdown-item">
                    💬 Mensajes
                    <?php
                    $mensajesNuevos = $db->fetchOne("SELECT COUNT(*) as total FROM chat_interno WHERE receptor_id = ? AND leido = 0", [$currentUser['id']]);
                    if ($mensajesNuevos['total'] > 0):
                    ?>
                        <span class="notification-badge"><?= $mensajesNuevos['total'] ?></span>
                    <?php endif; ?>
                </a>
                <a href="#" class="user-dropdown-item">
                    ⚙️ Configuración
                </a>
                <a href="/lexipro/logout.php" class="user-dropdown-item" style="color: #ef4444;">
                    🚪 Cerrar Sesión
                </a>
            </div>
        </div>
    </div>
</div>

<script>
function toggleUserMenu() {
    document.getElementById('userDropdown').classList.toggle('show');
}

function toggleNotifications() {
    // TODO: Implementar panel de notificaciones
    alert('Panel de notificaciones en desarrollo');
}

// Cerrar dropdown al hacer click fuera
document.addEventListener('click', function(event) {
    const userMenu = document.querySelector('.user-menu');
    if (!userMenu.contains(event.target)) {
        document.getElementById('userDropdown').classList.remove('show');
    }
});

// Búsqueda global
document.getElementById('globalSearch').addEventListener('input', function(e) {
    const query = e.target.value;
    if (query.length >= 3) {
        // TODO: Implementar búsqueda global
        console.log('Buscando:', query);
    }
});

// Cargar contador de notificaciones
async function loadNotificationCount() {
    try {
        const response = await fetch('/lexipro/modules/chat/api.php?no_leidos=1');
        const data = await response.json();
        if (data.success && data.no_leidos > 0) {
            document.getElementById('notificationCount').textContent = data.no_leidos;
            document.getElementById('notificationCount').style.display = 'flex';
        }
    } catch (error) {
        console.error('Error al cargar notificaciones:', error);
    }
}

// Actualizar cada 30 segundos
loadNotificationCount();
setInterval(loadNotificationCount, 30000);
</script>
