<?php
// contact_api.php

header('Content-Type: application/json');

$contactsFile = 'contacts.json';

// Asegurarse de que el archivo de contactos exista y sea un JSON válido
if (!file_exists($contactsFile) || !is_readable($contactsFile) || filesize($contactsFile) === 0) {
    file_put_contents($contactsFile, '[]');
}

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    // --- MANEJAR SOLICITUDES GET para obtener los contactos ---
    try {
        $contacts = file_get_contents($contactsFile);
        echo $contacts;
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['status' => 'error', 'message' => 'No se pudieron leer los contactos.']);
    }
} elseif ($method === 'POST') {
    // --- MANEJAR SOLICITUDES POST para guardar un nuevo contacto ---
    $inputData = json_decode(file_get_contents('php://input'), true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'Datos inválidos recibidos.']);
        exit;
    }

    $contacts = json_decode(file_get_contents($contactsFile), true);

    // Comprobar si la acción es 'delete'
    if (isset($inputData['action']) && $inputData['action'] === 'delete') {
        $identifierToDelete = $inputData['identifier'];
        
        // Filtrar el array, manteniendo todos los contactos excepto el que coincide con el identificador
        $updatedContacts = array_filter($contacts, function($contact) use ($identifierToDelete) {
            return $contact['received_at'] !== $identifierToDelete;
        });

        // Re-indexar el array para evitar huecos
        $updatedContacts = array_values($updatedContacts);

        file_put_contents($contactsFile, json_encode($updatedContacts, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        echo json_encode(['status' => 'success', 'message' => 'Contacto eliminado correctamente.']);
    } else {
        // Lógica original para añadir un nuevo contacto
        $newContact = $inputData;
        $newContact['received_at'] = date('Y-m-d H:i:s');
        array_unshift($contacts, $newContact);
        file_put_contents($contactsFile, json_encode($contacts, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        echo json_encode(['status' => 'success', 'message' => 'Contacto guardado correctamente.']);
    }
}
?>