<?php
// clients_api.php

header('Content-Type: application/json');

$clientsFile = 'clients.json';

// Asegurarse de que el archivo de clientes exista y sea un JSON válido
if (!file_exists($clientsFile) || !is_readable($clientsFile) || filesize($clientsFile) === 0) {
    file_put_contents($clientsFile, '[]');
}

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    // --- MANEJAR SOLICITUDES GET para obtener los clientes ---
    try {
        $clients = file_get_contents($clientsFile);
        echo $clients;
    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['status' => 'error', 'message' => 'No se pudieron leer los clientes.']);
    }
} elseif ($method === 'POST') {
    // --- MANEJAR SOLICITUDES POST para guardar un nuevo cliente ---
    $inputData = json_decode(file_get_contents('php://input'), true);

    if (json_last_error() !== JSON_ERROR_NONE) {
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'Datos inválidos recibidos.']);
        exit;
    }

    $clients = json_decode(file_get_contents($clientsFile), true);

    // Determinar la acción a realizar
    // La acción ahora debe ser enviada explícitamente desde el frontend para mayor claridad.
    $action = isset($inputData['action']) ? $inputData['action'] : '';

    // Eliminar 'action' de los datos para que no se guarde en el JSON del cliente.
    if (isset($inputData['action'])) {
        unset($inputData['action']);
    }

    if ($action === 'delete') {
        $identifierToDelete = $inputData['identifier'];
        $updatedClients = array_values(array_filter($clients, function($client) use ($identifierToDelete) {
            return $client['created_at'] !== $identifierToDelete;
        }));
        file_put_contents($clientsFile, json_encode($updatedClients, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        echo json_encode(['status' => 'success', 'message' => 'Cliente eliminado correctamente.']);

    } elseif ($action === 'update') {
        $identifierToUpdate = $inputData['created_at'];
        $updatedClients = array_map(function($client) use ($identifierToUpdate, $inputData) {
            if ($client['created_at'] === $identifierToUpdate) {
                return array_merge($client, $inputData); // Actualiza el cliente con los nuevos datos
            }
            return $client;
        }, $clients);
        file_put_contents($clientsFile, json_encode($updatedClients, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        echo json_encode(['status' => 'success', 'message' => 'Cliente actualizado correctamente.', 'client' => $inputData]);

    } elseif ($action === 'create') {
        $newClient = $inputData;
        $newClient['created_at'] = date('Y-m-d H:i:s');
        array_unshift($clients, $newClient);
        file_put_contents($clientsFile, json_encode($clients, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        echo json_encode(['status' => 'success', 'message' => 'Cliente guardado correctamente.']);
    } else {
        // Si no se especifica una acción válida, devolver un error.
        http_response_code(400);
        echo json_encode(['status' => 'error', 'message' => 'Acción no especificada o inválida.']);
    }
}
?>