<?php
// api.php

header('Content-Type: application/json');

$databaseFile = 'database.json';

// Asegurarse de que el archivo de la base de datos exista
if (!file_exists($databaseFile)) {
    // Si no existe, lo creamos con un objeto JSON vacío
    file_put_contents($databaseFile, '{}');
}

$method = $_SERVER['REQUEST_METHOD'];

if ($method === 'GET') {
    // --- MANEJAR SOLICITUDES GET ---
    // Simplemente lee el archivo y lo devuelve.
    try {
        $json_data = file_get_contents($databaseFile);
        $data = json_decode($json_data, true);

        // Asegurarse de que las claves principales existan
        if (!isset($data['fontSettings'])) $data['fontSettings'] = new stdClass();
        if (!isset($data['siteContent'])) $data['siteContent'] = new stdClass();
        if (!isset($data['legalCaseTypes'])) $data['legalCaseTypes'] = [];

        // **CORRECCIÓN**: Asegurarse de que colorPalette y fontSettings sean objetos.
        // Si son arrays vacíos en el JSON, se convierten a objetos vacíos.
        if (isset($data['colorPalette']) && is_array($data['colorPalette']) && empty($data['colorPalette'])) {
            $data['colorPalette'] = new stdClass();
        }
        if (isset($data['fontSettings']) && is_array($data['fontSettings']) && empty($data['fontSettings'])) {
            $data['fontSettings'] = new stdClass();
        }

        // Devolver los datos corregidos como JSON
        echo json_encode($data);

    } catch (Exception $e) {
        http_response_code(500);
        echo json_encode(['status' => 'error', 'message' => 'No se pudo leer la base de datos.']);
    }
} elseif ($method === 'POST') {
    // --- MANEJAR SOLICITUDES POST ---
    // Lee el cuerpo de la solicitud (que contiene los nuevos datos)
    $inputJSON = file_get_contents('php://input');
    $inputData = json_decode($inputJSON, true);

    // Validar que el JSON recibido es válido
    if (json_last_error() !== JSON_ERROR_NONE) {
        http_response_code(400); // Bad Request
        echo json_encode(['status' => 'error', 'message' => 'JSON inválido recibido.']);
        exit;
    }
    
    // **CORRECCIÓN**: Distinguir entre una solicitud POST para obtener datos y una para guardar.
    if (isset($inputData['action']) && $inputData['action'] === 'get') {
        // Si la acción es 'get', se comporta como una solicitud GET.
        $json_data = file_get_contents($databaseFile);
        $data = json_decode($json_data, true);

        // Asegurarse de que las claves principales existan
        if (!isset($data['fontSettings'])) $data['fontSettings'] = new stdClass();
        if (!isset($data['siteContent'])) $data['siteContent'] = new stdClass();
        if (!isset($data['legalCaseTypes'])) $data['legalCaseTypes'] = [];
        
        if (isset($data['colorPalette']) && is_array($data['colorPalette']) && empty($data['colorPalette'])) {
            $data['colorPalette'] = new stdClass();
        }
        if (isset($data['fontSettings']) && is_array($data['fontSettings']) && empty($data['fontSettings'])) {
            $data['fontSettings'] = new stdClass();
        }
        echo json_encode($data);
    } else {
        // Si no hay acción 'get', es una solicitud para guardar los datos.
        file_put_contents($databaseFile, json_encode($inputData, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE));
        echo json_encode(['status' => 'success', 'message' => 'Datos guardados correctamente.']);
    }
} else {
    // Si se usa otro método (PUT, DELETE, etc.), devolvemos un error.
    http_response_code(405); // Method Not Allowed
    echo json_encode(['status' => 'error', 'message' => 'Método no permitido.']);
}
?>