# LexiPro - Sistema de Gestión Jurídica

![LexiPro](https://img.shields.io/badge/version-1.0.0-blue.svg)
![PHP](https://img.shields.io/badge/PHP-7.4+-purple.svg)
![MySQL](https://img.shields.io/badge/MySQL-5.7+-orange.svg)
![License](https://img.shields.io/badge/license-MIT-green.svg)

Sistema completo de gestión para abogados y estudios jurídicos desarrollado en PHP, JavaScript y MySQL.

## 🚀 Características Principales

### ✅ Implementadas (Fases 1-3)

- **Gestión de Usuarios**
  - CRUD completo con roles y permisos granulares
  - 8 roles predefinidos (Admin, Abogado Senior/Junior, Notario, Actuario, Secretario, Oficial, Gestor)
  - Fotos de perfil
  - Tipos de pago (por hora o mensual)
  - Proveedores externos

- **Gestión de Casos**
  - Vista Kanban y Tabla
  - Generación automática de números de caso
  - Asignación de responsables y equipos
  - Estados: Abierto, En Proceso, Suspendido, Cerrado, Archivado
  - Prioridades: Baja, Media, Alta, Urgente
  - Información completa: tipo, materia, juzgado, expediente

- **Sistema de Tareas**
  - Tareas por caso con responsables
  - Plazos jurídicos con alertas especiales
  - Registro de horas trabajadas
  - Estados y prioridades
  - Notificaciones automáticas

- **Sistema de Notificaciones**
  - Alertas automáticas de asignaciones
  - Notificaciones de plazos jurídicos
  - Registro de actividades

### 🚧 Próximas Fases (4-16)

- Sistema de Agenda con calendario
- Chat dual (público + interno)
- Facturación según RG90 Paraguay
- Contabilidad completa
- Cálculo de honorarios/salarios
- Asistente IA con Gemini
- Biblioteca jurídica
- Reportes y analytics
- Gestor de archivos

## 📋 Requisitos del Sistema

- **PHP**: 7.4 o superior
- **MySQL**: 5.7 o superior
- **Extensiones PHP**:
  - PDO
  - PDO MySQL
  - MBString
  - GD (para manejo de imágenes)
- **Servidor Web**: Apache con mod_rewrite
- **Permisos**: Escritura en el directorio del proyecto

## 🔧 Instalación

### Opción 1: Instalador Web (Recomendado)

1. **Descarga y Extracción**
   ```bash
   # Clonar o descargar el proyecto
   cd c:\xampp\htdocs\
   # Copiar archivos de LexiPro aquí
   ```

2. **Configurar Base de Datos**
   - Inicia XAMPP (Apache + MySQL)
   - Abre phpMyAdmin: `http://localhost/phpmyadmin`
   - Crea una base de datos llamada `lexipro` (opcional, el instalador puede crearla)

3. **Ejecutar Instalador**
   - Abre en tu navegador: `http://localhost/lexipro/install/`
   - Sigue los 5 pasos del instalador:
     1. Verificación de requisitos
     2. Configuración de base de datos
     3. Creación de tablas
     4. Usuario administrador
     5. Datos de la empresa

4. **Seguridad Post-Instalación**
   ```bash
   # Eliminar o renombrar carpeta de instalación
   cd c:\xampp\htdocs\lexipro
   rename install install_backup
   ```

5. **Acceder al Sistema**
   - URL: `http://localhost/lexipro/login.php`
   - Usuario: El que creaste en el instalador
   - Contraseña: La que definiste

### Opción 2: Instalación Manual

1. **Importar Base de Datos**
   ```bash
   mysql -u root -p < install/database.sql
   ```

2. **Configurar Conexión**
   - Copia `config/config.example.php` a `config/config.php`
   - Edita los datos de conexión

3. **Crear Usuario Admin**
   ```sql
   INSERT INTO usuarios (nombre, apellido, usuario, password, email, rol_id, activo)
   VALUES ('Admin', 'Sistema', 'admin', '$2y$10$...', 'admin@lexipro.com', 1, 1);
   ```

4. **Configurar Permisos**
   ```bash
   chmod -R 755 uploads/
   chmod -R 755 config/
   ```

## 📁 Estructura del Proyecto

```
lexipro/
├── assets/
│   ├── css/
│   │   └── lexipro.css          # Estilos globales
│   ├── js/
│   │   └── lexipro.js           # JavaScript global
│   └── img/
│       └── default-avatar.png   # Avatar por defecto
│
├── config/
│   ├── config.php               # Configuración (generado por instalador)
│   └── database.php             # Clase de conexión PDO
│
├── includes/
│   ├── auth.php                 # Autenticación y permisos
│   └── functions.php            # Funciones auxiliares (30+)
│
├── install/
│   ├── index.php                # Instalador web
│   └── database.sql             # Esquema de base de datos
│
├── modules/
│   ├── usuarios/
│   │   ├── index.php            # Gestión de usuarios
│   │   └── api.php              # API REST de usuarios
│   ├── casos/
│   │   ├── index.php            # Gestión de casos (Kanban/Tabla)
│   │   ├── view.php             # Vista detallada de caso
│   │   └── api.php              # API REST de casos
│   ├── tareas/
│   │   └── api.php              # API REST de tareas
│   └── clientes/
│       └── api.php              # API de clientes
│
├── uploads/                     # Archivos subidos
│   ├── usuarios/
│   ├── casos/
│   └── archivos/
│
├── .htaccess                    # Configuración Apache
├── login.php                    # Página de login
├── logout.php                   # Cerrar sesión
└── README.md                    # Este archivo
```

## 🎯 Uso del Sistema

### Primer Acceso

1. **Login**
   - Accede a `http://localhost/lexipro/login.php`
   - Ingresa con las credenciales de administrador

2. **Configurar Empresa**
   - Ve a Configuración
   - Sube el logo de tu estudio
   - Completa datos de facturación (RUC, timbrado, etc.)

3. **Crear Usuarios**
   - Ve a Gestión de Usuarios
   - Crea usuarios para tu equipo
   - Asigna roles y permisos

4. **Crear Primer Caso**
   - Ve a Gestión de Casos
   - Click en "Nuevo Caso"
   - Completa la información
   - Asigna responsable y equipo

### Gestión de Casos

**Vista Kanban**
- Visualiza casos por estado
- Arrastra y suelta para cambiar estado
- Código de colores por prioridad

**Vista Tabla**
- Lista completa de casos
- Filtros avanzados
- Exportación de datos

**Tareas**
- Crea tareas para cada caso
- Marca plazos jurídicos importantes
- Registra horas trabajadas
- Recibe notificaciones automáticas

### Sistema de Permisos

Cada rol tiene permisos configurables por módulo:
- **Ver**: Acceso de lectura
- **Crear**: Crear nuevos registros
- **Editar**: Modificar registros
- **Eliminar**: Borrar registros

## 🔒 Seguridad

- Contraseñas hasheadas con `password_hash()`
- Protección CSRF en formularios
- Validación de permisos en cada endpoint
- Sanitización de inputs
- Protección de archivos sensibles
- Sesiones seguras

## 🛠️ Desarrollo

### Agregar Nuevo Módulo

1. Crear carpeta en `modules/nombre_modulo/`
2. Crear `api.php` con endpoints REST
3. Crear `index.php` con interfaz
4. Agregar permisos en tabla `permisos`
5. Actualizar menú principal

### Funciones Auxiliares Disponibles

```php
// Formateo
formatDate($date)              // Formato: dd/mm/yyyy
formatDateTime($datetime)      // Formato: dd/mm/yyyy HH:mm
formatMoney($amount)           // Formato: Gs. 1.000.000

// Validación
validateEmail($email)
validateRUC($ruc)
validateCedula($cedula)

// Archivos
uploadFile($file, $directory)
deleteFile($filepath)

// Notificaciones
createNotification($userId, $tipo, $titulo, $mensaje, $url)
getUnreadNotifications($userId)

// Logging
logActivity($userId, $accion, $modulo, $moduloId, $detalles)

// Respuestas JSON
jsonSuccess($data, $message)
jsonError($message, $statusCode)
```

## 📊 Base de Datos

### Tablas Principales

- `configuracion` - Datos de la empresa
- `roles` - Roles del sistema
- `usuarios` - Usuarios del sistema
- `permisos` - Permisos por rol
- `clientes` - Base de clientes
- `casos` - Casos jurídicos
- `tareas` - Tareas de casos
- `agenda` - Eventos y citas
- `facturas_ventas` - Facturación
- `facturas_compras` - Compras
- `plan_cuentas` - Contabilidad
- `chat_interno` - Chat del sistema
- `chat_web` - Chat público
- `notificaciones` - Alertas
- `biblioteca` - Biblioteca jurídica

## 🐛 Solución de Problemas

### Error de Conexión a Base de Datos

```
Verifica:
1. MySQL está corriendo
2. Credenciales en config/config.php son correctas
3. Base de datos existe
4. Usuario tiene permisos
```

### Permisos de Archivos

```bash
# Windows (XAMPP)
icacls uploads /grant Users:F /T

# Linux
chmod -R 755 uploads/
chown -R www-data:www-data uploads/
```

### Sesión No Persiste

```
Verifica:
1. session_start() se llama antes de cualquier output
2. Cookies están habilitadas en el navegador
3. session.save_path tiene permisos de escritura
```

## 📝 Changelog

### Versión 1.0.0 (2025-01-27)

**Agregado:**
- Instalador web de 5 pasos
- Sistema de autenticación y permisos
- Gestión completa de usuarios
- Gestión de casos con Kanban
- Sistema de tareas con plazos jurídicos
- Notificaciones automáticas
- 30+ tablas de base de datos
- API REST para usuarios, casos y tareas

## 🤝 Contribuir

Este es un proyecto privado para estudios jurídicos. Para solicitudes de características o reportar bugs, contacta al administrador del sistema.

## 📄 Licencia

Copyright © 2025 LexiPro. Todos los derechos reservados.

## 📞 Soporte

Para soporte técnico o consultas:
- Email: soporte@lexipro.com
- Documentación: `/docs/`

---

**Desarrollado con ❤️ para abogados y estudios jurídicos**
