document.addEventListener('DOMContentLoaded', function () {

    // --- ELEMENTOS DEL DOM ---
    const projectListContainer = document.getElementById('project-media-plan-list');

    // --- URLs DE LA API ---
    const PROJECTS_API_URL = 'api/projects.php';

    // --- FUNCIONES DE CARGA INICIAL ---

    async function initialLoad() {
        try {
            const projectsRes = await fetch(PROJECTS_API_URL);
            if (!projectsRes.ok) throw new Error('No se pudieron cargar los proyectos.');
            
            const projects = await projectsRes.json();
            renderProjectList(projects);

        } catch (error) {
            console.error("Error en la carga inicial:", error);
            projectListContainer.innerHTML = `<div class="alert alert-danger">${error.message}</div>`;
        }
    }

    function renderProjectList(projects) {
        projectListContainer.innerHTML = '';
        if (projects.length === 0) {
            projectListContainer.innerHTML = '<p class="text-muted">No hay proyectos creados. Cree un proyecto para poder asignarle un plan de medios.</p>';
            return;
        }

        projects.forEach(project => {
            const projectItem = document.createElement('a');
            // Este enlace apuntará a una futura página de detalle del plan de medios
            projectItem.href = `media-plan-detail.html?project_id=${project.id}`;
            projectItem.className = 'list-group-item list-group-item-action d-flex justify-content-between align-items-center';
            projectItem.innerHTML = `
                <div>
                    <h5 class="mb-1">${project.nombre_proyecto}</h5>
                    <small>Tipo de Marketing: ${project.tipo_marketing} | Estado: ${project.estado}</small>
                </div>
                <i class="bi bi-arrow-right-circle-fill fs-4"></i>
            `;
            projectListContainer.appendChild(projectItem);
        });
    }

    // --- CARGA INICIAL ---
    initialLoad();
});