document.addEventListener('DOMContentLoaded', () => {
    const darkModeToggle = document.getElementById('dark-mode-toggle');
    const body = document.body;

    const darkModeStateKey = 'darkModeEnabled';

    // --- Lógica del Modo Oscuro ---
    // Aplicar estado guardado del modo oscuro al cargar
    const isDarkModeEnabled = localStorage.getItem(darkModeStateKey) === 'true';
    if (isDarkModeEnabled) {
        body.classList.add('dark-mode');
        if (darkModeToggle) darkModeToggle.checked = true;
    }

    // Manejar clic en el interruptor de modo oscuro
    if (darkModeToggle) {
        darkModeToggle.addEventListener('change', () => {
            if (darkModeToggle.checked) {
                body.classList.add('dark-mode');
                localStorage.setItem(darkModeStateKey, 'true');
            } else {
                body.classList.remove('dark-mode');
                localStorage.setItem(darkModeStateKey, 'false');
            }
        });
    }
});